/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_interactive;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.document.annotation.TestCases;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerInteractBlockPreEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2478;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_8242;
import org.jetbrains.annotations.NotNull;

@Document(id=1751824965598L, value="This module allows you to write commands in `sign` block.\nAnd then click to execute commands.\n")
@ColorBoxes(value={@ColorBox(id=1751870448041L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 How it works?\n\nIf a player `right click` a `sign block`.\nWe will check if the `facing texts` contains the `/` character.\nIf contains, we will treat as the player issue the command.\n"), @ColorBox(id=1751968326784L, color=ColorBox.ColorBoxTypes.TIPS, value="A `sign block` that contains the `character /` is called an `interactive sign block`.\nYou can use `right click` to execute the commands written on the interactive sign block.\nYou can use `shift + right click` to edit an `interactive sign block`.\n"), @ColorBox(id=1751968409125L, color=ColorBox.ColorBoxTypes.TIPS, value="You can write some comment text before the first `character /`.\nAll 4 lines will be joined and treated as one single big line.\nSo be careful with the `space character`, and ignore the `linefeed character`.\n")})
@TestCases(value={@TestCase(action="Test the `command_interactive` module in `online-mode` server.", targets={"The packet should not break the client-side signature validation."}), @TestCase(action="Enable `command_warmup` module, issue `/back` command.", targets={"It should work with un-signed argument type."}), @TestCase(action="Enable `command_warmup` module, issue `/say hi` command.", targets={"It should work with signed argument type."})})
public class CommandInteractiveInitializer
extends ModuleInitializer {
    private static final String COMMAND_STRING_SPLIT_CHARACTER = "/";

    @NotNull
    private static String mapSignTextIntoString(@NotNull class_8242 signText) {
        return Arrays.stream(signText.method_49877(false)).map(class_2561::getString).reduce("", String::concat);
    }

    @NotNull
    private static List<String> splitCommands(@NotNull String string) {
        int left = string.indexOf(COMMAND_STRING_SPLIT_CHARACTER);
        string = string.substring(left + 1);
        String[] split = string.split(COMMAND_STRING_SPLIT_CHARACTER);
        return Arrays.stream(split).map(String::trim).collect(Collectors.toCollection(ArrayList::new));
    }

    private static boolean canUseInteractiveCommand(@NotNull class_3222 player) {
        return player.method_5715();
    }

    @EventConsumer(injectorPriority=999, consumerPriority=999)
    private static void consumePlayerInteractBlockPreEvent(PlayerInteractBlockPreEvent event) {
        class_2625 signBlockEntity;
        class_8242 facingSignText;
        String facingSignLines;
        class_2338 blockPos;
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        class_1937 world = event.getWorld();
        class_2680 blockState = world.method_8320(blockPos = event.getBlockHitResult().method_17777());
        if (!(blockState.method_26204() instanceof class_2478)) {
            return;
        }
        class_3222 player = event.getPlayer();
        if (CommandInteractiveInitializer.canUseInteractiveCommand(player)) {
            return;
        }
        class_2586 interactingBlockEntity = world.method_8321(blockPos);
        if (interactingBlockEntity instanceof class_2625 && (facingSignLines = CommandInteractiveInitializer.mapSignTextIntoString(facingSignText = (signBlockEntity = (class_2625)interactingBlockEntity).method_49843(signBlockEntity.method_49834((class_1657)player)))).contains(COMMAND_STRING_SPLIT_CHARACTER)) {
            event.getCallbackInfoReturnable().setReturnValue((Object)class_1269.field_21466);
            List<String> commands = CommandInteractiveInitializer.splitCommands(facingSignLines).stream().map(str -> TextHelper.Parsers.parsePlaceholderString(player, str)).toList();
            commands.forEach(commandString -> CommandExecutor.executeSingle(ExtendedCommandSource.asPlayer(player.method_64396(), player), commandString));
        }
    }
}

