/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.chain;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;

@Document(id=1751824730196L, value="Provides `/chain` command.\nIt allows you to run another 2 commands.\nThe first command is `any command`.\nThe second command is `the chain command`.\n")
@ColorBoxes(value={@ColorBox(id=1751870431402L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 What is the purpose of `/chain` command?\nIts typical use-case is to `condense` two commands into one command.\nSo that you can put `more than 1 command` in some places.\nFor example: `/execute run chain say 1 chain say 2`\n\n\u25c9 The `return value` of a vanilla Minecraft command.\nIn vanilla Minecraft, the `return value` of a command, is a `integer`.\nIf integer less than zero, it's `failed`.\nIf integer equals zero, it's `passed`.\nIf integer grater than zero, it's `success`.\n\n<green>So, we can know whether a command was executed successfully or not, based on the return value of that command.\n\n\u25c9 How the `/chain` command works?\nThe `/chain` command takes `exactly one argument`, whose type is `greedy string`.\nA `greedy string` argument type is always be `the last` argument of a command.\nOnce the `command parser` sees a `greedy string` argument type, it knows this is `the last` argument.\nSo the parser will `feed` the `greedy string argument` all the remaining characters.\nIn other words, a `greedy string argument` will `eat` all the remaining characters that are still not be consumed by preceding arguments.\n\nFor example, the `/say Hello Alice` also has exactly one argument, whose type is `greedy string`.\nYou didn't need to use `\"` character to escape the `space character`, this is because the argument type of `/say` is `greedy string`.\n\nTake `/chain say 1 chain say 2` as an example:\nThe first `/chain` command will receive the `say 1 chain say 2` as the value of `its first and only argument`.\nThen the `/chain` command will split the value into two parts.\nThe first part is `say 1`, and the `/chain` command will submit it to the `command executor`.\nThe second part is `chain say 2`, and the `/chain` command will decide whether to submit it `based on` the return value of `the previous submitted command`.\nIt's a recursive process.\n"), @ColorBox(id=1751969034903L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 A nested chain\nIssue: `/chain say 1 chain say 2 chain say 3`\n\n\u25c9 A breakable chain\nIssue: `/chain bad command here chain say 2`\n\n\u25c9 Use chain command with predicate command\nIssue: `/run as player Alice chain test-level-perm %player:name% 4 chain say value is true`\n\n\u25c9 Leverage the `/execute if` command.\nIssue: `/chain execute if block ~ ~-1 ~ minecraft:diamond_block if entity @s[nbt={Inventory:[{id:\"minecraft:diamond\"}]}] chain say You are standing on diamond block and have diamond.`\n<green>NOTE: This use-case is similar to `command_meta.if` module.\n")})
public class ChainInitializer
extends ModuleInitializer {
    private static final Pattern CHAIN_COMMAND_PARSER = Pattern.compile("(.+?)\\s+(chain .+)");

    @Document(id=1751824736793L, value="Chain commands and executes them in sequence, the chain will break if the previous one command fails.")
    @CommandNode(value="chain")
    @CommandRequirement(level=4)
    private static int $chain(@CommandSource class_2168 source, GreedyString rest) {
        String $rest = (String)rest.getValue();
        Matcher matcher = CHAIN_COMMAND_PARSER.matcher($rest);
        if (matcher.find()) {
            String first = matcher.group(1);
            String second = matcher.group(2);
            int value = CommandExecutor.executeSingle(ExtendedCommandSource.fromSource(source), first);
            if (CommandHelper.Return.isSuccess(value)) {
                CommandExecutor.executeSingle(ExtendedCommandSource.fromSource(source), second);
            }
        } else {
            CommandExecutor.executeSingle(ExtendedCommandSource.fromSource(source), $rest);
        }
        return 1;
    }
}

