/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.json;

import com.google.gson.JsonElement;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.core.config.parser.JsonPathParser;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_meta.json.command.argument.wrapper.JsonValueType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiFunction;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@Document(id=1751823967217L, value="Provides `/json` command.\nA powerful and unified tool to edit json file.\n")
@ColorBoxes(value={@ColorBox(id=1751969995780L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Read a json key.\nIssue: `/json read \"config/fuji/config.json\" \"$.core.debug\"`\n\n\u25c9 List json keys.\nIssue: `/json read \"config/fuji/config.json\" \"$.modules.keys()\"`\n\n\u25c9 Set the value of a json key.\nIssue: `/json write \"config/fuji/config.json\" \"$.core.debug.log_debug_messages\" BOOLEAN true`\n"), @ColorBox(id=1751970168900L, color=ColorBox.ColorBoxTypes.TIPS, value="Read the detailed document for `Json Path`:\nSee https://goessner.net/articles/JsonPath/\n")})
@CommandNode(value="json")
@CommandRequirement(level=4)
public class JsonInitializer
extends ModuleInitializer {
    private static void operateJson(String filePath, BiFunction<DocumentContext, Path, Boolean> function) {
        block4: {
            Path path = Path.of(filePath, new String[0]);
            DocumentContext documentContext = JsonPathParser.getJsonPathParser().parse(path.toFile());
            Boolean destructiveFlag = function.apply(documentContext, path);
            if (!destructiveFlag.booleanValue()) break block4;
            String json = GsonMapper.toJsonString((JsonElement)documentContext.json());
            try {
                Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                throw ExceptionUtil.makeReThrownException(e);
            }
        }
    }

    @CommandNode(value="read")
    private static int $read(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            Object read = documentContext.read(jsonPath, new Predicate[0]);
            TextHelper.sendMessageByText(ctx.getSource(), (class_2561)class_2561.method_43470((String)read.toString()));
            return false;
        });
        return 1;
    }

    @CommandNode(value="write")
    private static int $write(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath, JsonValueType valueType, GreedyString value) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            Object obj = valueType.parse((String)value.getValue());
            documentContext.set(jsonPath, obj, new Predicate[0]);
            return true;
        });
        return 1;
    }

    @CommandNode(value="delete")
    private static int $delete(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            documentContext.delete(jsonPath, new Predicate[0]);
            return true;
        });
        return 1;
    }

    @CommandNode(value="put")
    private static int $put(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath, String jsonKey, JsonValueType valueType, GreedyString value) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            Object obj = valueType.parse((String)value.getValue());
            documentContext.put(jsonPath, jsonKey, obj, new Predicate[0]);
            return true;
        });
        return 1;
    }

    @CommandNode(value="renameKey")
    private static int $renameKey(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath, String oldJsonKey, String newJsonKey) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            documentContext.renameKey(jsonPath, oldJsonKey, newJsonKey, new Predicate[0]);
            return true;
        });
        return 1;
    }
}

