/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_meta.shell;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.fuji.core.auxiliary.AsyncUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_meta.shell.config.ShellConfigModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@Document(id=1751824777515L, value="Provides `/shell` command.\nTo execute the `command line` in `host shell`.\n\nA `powerful` and `dangerous` module.\n")
@ColorBoxes(value={@ColorBox(id=1751870434188L, color=ColorBox.ColorBoxTypes.DANGER, value="\u25c9 This is a `dangerous` module.\nThis module is a powerful and dangerous module, not recommended to enable it.\n"), @ColorBox(id=1751970272178L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a file using placeholder.\nIssue: `/shell touch %player:name%.dangerous`\n\n\u25c9 Execute a program in the host machine.\nIssue: `/shell emacs`\n\n\u25c9 Call a program in the host machine, to backup your server.\nYou need to combine `shell` module with `command_scheduler` module.\nAnd setup the `external backup program`.\nSee more in https://rdiff-backup.net/\n\n\u25c9 Download a virus from the Internet, and execute it.\nIssue: `/shell ...`\n")})
public class ShellInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ShellConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ShellConfigModel.class);

    private static void checkSecurity(CommandContext<class_2168> ctx) {
        ShellConfigModel config = ShellInitializer.config.model();
        if (!config.enable_warning.equals("CONFIRM")) {
            TextHelper.sendTextByKey(ctx.getSource(), "shell.failed.rtfm", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        if (config.security.only_allow_console && ((class_2168)ctx.getSource()).method_44023() != null) {
            TextHelper.sendTextByKey(ctx.getSource(), "command.console_only", new Object[0]);
            throw new AbortCommandExecutionException();
        }
        if (((class_2168)ctx.getSource()).method_9214() != null && !config.security.allowed_player_names.contains(((class_2168)ctx.getSource()).method_9214())) {
            TextHelper.sendTextByKey(ctx.getSource(), "shell.failed.not_in_allowed_list", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @Document(id=1751824784016L, value="Execute a shell command in host os.")
    @CommandNode(value="shell")
    @CommandRequirement(level=4)
    private static int $shell(@CommandSource CommandContext<class_2168> ctx, GreedyString rest) {
        ShellInitializer.checkSecurity(ctx);
        String commandString = (String)rest.getValue();
        AsyncUtil.runAsyncAndHandleExceptions(() -> {
            try {
                LogUtil.info("Shell exec: {}", commandString);
                String[] commandTokens = commandString.split("\\s");
                Process process = Runtime.getRuntime().exec(commandTokens, null, null);
                InputStream inputStream = process.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                try {
                    String line;
                    StringBuilder output = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        output.append(line).append("\n");
                    }
                    process.waitFor();
                    LogUtil.info(output.toString(), new Object[0]);
                    TextHelper.sendMessageByText(ctx.getSource(), (class_2561)class_2561.method_43470((String)output.toString()));
                }
                finally {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                LogUtil.error("Failed to execute the shell command: {}", commandString, e);
            }
        });
        return 1;
    }
}

