/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_permission.structure;

import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.module.initializer.command_permission.CommandPermissionInitializer;
import io.github.sakurawald.fuji.module.initializer.command_permission.service.CommandPermissionService;
import io.github.sakurawald.fuji.module.initializer.command_permission.structure.CommandPermissionRule;
import java.util.function.Predicate;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

@TestCase(action="Issue `/fuji reload` and `/reload` commands in `neoforge single player world`.", targets={"It should not trigger the Concurrent Modification Exception."})
public class WrappedPredicate<T>
implements Predicate<T> {
    private final CommandNode<class_2168> commandNode;
    private final Predicate<Object> originalRequirement;
    private String commandPath;

    public WrappedPredicate(CommandNode<class_2168> commandNode, Predicate<Object> originalRequirement) {
        this.commandNode = commandNode;
        this.originalRequirement = originalRequirement;
    }

    public String getCachedCommandPath() {
        if (this.commandPath == null) {
            this.commandPath = CommandHelper.Node.findCommandNodePath(this.commandNode);
        }
        return this.commandPath;
    }

    @Override
    public boolean test(@NotNull Object commandSource) {
        if (commandSource instanceof class_2168) {
            class_2168 serverCommandSource = (class_2168)commandSource;
            try {
                if (serverCommandSource.method_44023() == null) {
                    return this.originalRequirement.test(commandSource);
                }
                String commandPath = this.getCachedCommandPath();
                if (!CommandHelper.Requirement.isAdmin(serverCommandSource)) {
                    String requiredPermissionToExecuteThisCommand = CommandPermissionInitializer.COMMAND_PERMISSION_UNIFIED_PERMISSION.withArguments(commandPath);
                    for (CommandPermissionRule rule : CommandPermissionInitializer.config.model().rules) {
                        if (!requiredPermissionToExecuteThisCommand.matches(rule.permissionPatternRegex)) continue;
                        Tristate predefinePermissionTestResult = rule.permissionTestResult.toTriState();
                        CommandPermissionService.processVerboseModeFeature("PREDEFINED RULES", serverCommandSource, commandPath, predefinePermissionTestResult);
                        return CommandPermissionService.canUseThisCommand(serverCommandSource, predefinePermissionTestResult, this.originalRequirement);
                    }
                }
                Tristate luckpermsPermissionTestResult = LuckpermsHelper.getPermission(serverCommandSource.method_44023().method_5667(), CommandPermissionInitializer.COMMAND_PERMISSION_UNIFIED_PERMISSION, commandPath);
                CommandPermissionService.processVerboseModeFeature("LUCKPERMS", serverCommandSource, commandPath, luckpermsPermissionTestResult);
                return CommandPermissionService.canUseThisCommand(serverCommandSource, luckpermsPermissionTestResult, this.originalRequirement);
            }
            catch (Throwable useOriginalPredicateIfFailed) {
                LogUtil.error("Failed to test the command requirement using WrappedPredicate, falling back to original predicate. (command node = {}, source = {})", this.commandNode, serverCommandSource, useOriginalPredicateIfFailed);
                return this.originalRequirement.test(commandSource);
            }
        }
        return this.originalRequirement.test(commandSource);
    }
}

