/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_rewrite;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerCommandIssuePreEvent;
import io.github.sakurawald.fuji.core.structure.RegexRewriteNode;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.command_rewrite.config.model.CommandRewriteConfigModel;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826288031L, value="This module allows you to define `regex` to rewrite the command line a player issued.\n")
@ColorBoxes(value={@ColorBox(id=1756047806466L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n1. Intercept the `issued command string` packets.\n2. Apply the defined rewrite rules to `the command string` in top-down order.\n\n<blue>NOTE: The `command_rewrite` occurs at the very beginning of the command lifecycle.\n<blue>You will not receive `command suggestions` or `command exceptions` at this stage.\n<blue>The rewrite rules are applied directly to the raw command string.\n\n\u25c9 Command Lifecycle\n1. **Issuing** \u2013 The command is sent as `a raw string`. At this stage, no command suggestions or exceptions are available.\n2. **Parsing** \u2013 The command string is parsed into `a command node`. At this point, command suggestions and exceptions can be provided.\n3. **Execution** \u2013 The `actions` associated with the command node are `executed`, producing the intended `effects` of the command.\n"), @ColorBox(id=1751971980398L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The different compared to `command_alias` module and `command_bundle` module.\n1. The `command alias` module allows you to define `new command`, and redirects it into `an existing command`.\n2. The `command bundle` module allows you to define `new command`, and define the argument and body of the new command.\n3. The `command rewrite` module didn't define any new command. It just works in `network packet` level, and modifies the `issued command string` from the command source player.\n"), @ColorBox(id=1751971914915L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 You can use this module to shorten the command string.\nLike, rewrite the command string `/home` into `/home tp default`.\nAnd provide a shortcut, for `/home tp default` command.\n")})
@TestCase(action="Issue `/home` command.", targets={"It should be rewrite to `/home tp default` command."})
public class CommandRewriteInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandRewriteConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", CommandRewriteConfigModel.class);

    @NotNull
    private static String processCommandRewrite(@NotNull String oldString) {
        List<RegexRewriteNode> effectiveRewriteRules = CommandRewriteInitializer.config.model().rules.stream().filter(rule -> {
            boolean result;
            boolean bl = result = rule.getRegex() != null && rule.getReplacement() != null;
            if (!result) {
                LogUtil.warn("Both regex property and replacement property should not be null, ignoring the command rewrite rule: {}", rule);
            }
            return result;
        }).toList();
        for (RegexRewriteNode rewriteRule : effectiveRewriteRules) {
            if (!oldString.matches(rewriteRule.getRegex())) continue;
            String newString = oldString.replaceAll(rewriteRule.getRegex(), rewriteRule.getReplacement());
            LogUtil.debug("Rewrite the command string: old = {}, new = {}", oldString, newString);
            oldString = newString;
        }
        return oldString;
    }

    @EventConsumer(injectorPriority=0, consumerPriority=0)
    private static void consumePlayerCommandIssuePreEvent(PlayerCommandIssuePreEvent event) {
        if (event.getCallbackInfo().isCancelled()) {
            return;
        }
        String oldValue = event.getCommandString();
        String newValue = CommandRewriteInitializer.processCommandRewrite(oldValue);
        event.setCommandString(newValue);
    }
}

