/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_state.service;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.manager.impl.cache.structure.Cache;
import io.github.sakurawald.fuji.module.initializer.command_state.CommandStateInitializer;
import io.github.sakurawald.fuji.module.initializer.command_state.structure.PlayerStates;
import io.github.sakurawald.fuji.module.initializer.command_state.structure.StateDescriptor;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class CommandStateService {
    @NotNull
    public static List<StateDescriptor> listStateDescriptors() {
        return CommandStateInitializer.config.model().getStateDescriptors().stream().filter(StateDescriptor::isEnable).filter(it -> {
            boolean flag = it.getDefinition().getPredicateCommands().isEmpty();
            if (flag) {
                LogUtil.warn("Ignore the '{}' state descriptor. (Reason: empty definition)", it.getId());
            }
            return !flag;
        }).toList();
    }

    @NotNull
    public static List<String> listStateIds() {
        return CommandStateService.listStateDescriptors().stream().map(StateDescriptor::getId).toList();
    }

    public static Optional<StateDescriptor> findStateDescriptor(@NotNull String id) {
        return CommandStateService.listStateDescriptors().stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    public static void updateAllCommandStates() {
        CommandStateService.listStateDescriptors().forEach(CommandStateService::updateCommandState);
    }

    public static void updateCommandState(@NotNull StateDescriptor stateDescriptor) {
        LogUtil.disabled("Update the command state '{}' for online players.", stateDescriptor.getId());
        PlayerHelper.Lookup.getOnlinePlayers().forEach(player -> CommandStateService.updateCommandState(player, stateDescriptor));
    }

    public static void withPlayerStateMap(@NotNull class_3222 player, @NotNull Consumer<PlayerStates> consumer) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        PlayerStates playerStates = CommandStateInitializer.data.model().getPlayerStatesMap().computeIfAbsent(playerName, key -> new PlayerStates());
        consumer.accept(playerStates);
    }

    private static void executeCommandStateEventCommands(@NotNull class_3222 player, @NotNull StateDescriptor stateDescriptor, boolean isEnterEvent) {
        List<String> commands = isEnterEvent ? stateDescriptor.getEvents().getOnEnterThisStateCommands() : stateDescriptor.getEvents().getOnLeaveThisStateCommands();
        ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(player.method_64396());
        CommandExecutor.executeBatch(extendedCommandSource, commands);
    }

    private static void updateCommandState(@NotNull class_3222 player, @NotNull StateDescriptor stateDescriptor) {
        String stateId = stateDescriptor.getId();
        CommandStateService.withPlayerStateMap(player, playerStates -> playerStates.getStateMap().compute(stateId, (key, stateCache) -> {
            if (stateCache != null && !stateCache.isWithinExpirationDuration(Duration.ofSeconds(stateDescriptor.getUpdateIntervalSeconds()))) {
                return stateCache;
            }
            boolean currentStateStatus = CommandStateService.checkCurrentStateValue(player, stateDescriptor);
            if (stateCache == null || currentStateStatus != (Boolean)stateCache.getValue()) {
                CommandStateService.executeCommandStateEventCommands(player, stateDescriptor, currentStateStatus);
            }
            return Cache.of(currentStateStatus);
        }));
    }

    public static boolean checkCurrentStateValue(@NotNull class_3222 player, @NotNull StateDescriptor stateDescriptor) {
        ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(player.method_64396());
        List<String> predicateCommands = stateDescriptor.getDefinition().getPredicateCommands();
        List<Integer> commandReturnValues = CommandExecutor.executeBatch(extendedCommandSource, predicateCommands);
        return commandReturnValues.stream().allMatch(CommandHelper.Return::isSuccess);
    }
}

