/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.command_toolbox.reply;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.HashMap;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751972433657L, value="This module provides the `/reply` command.\nTo reply the player who recently `/msg` or `/tell` you.\n")
@ColorBox(id=1751972495394L, color=ColorBox.ColorBoxTypes.TIPS, value="You can use `command_alias` module, to create a new command `/r` as the alias to `/reply` command.\n")
public class ReplyInitializer
extends ModuleInitializer {
    private static final HashMap<String, String> player2replyTargetPlayer = new HashMap();

    public static void setReplyTarget(@NotNull String player, @NotNull String target) {
        player2replyTargetPlayer.put(player, target);
    }

    @Document(id=1751825375878L, value="Reply the player who recently /msg or /tell you.")
    @CommandNode(value="reply")
    private static int $reply(@CommandSource class_3222 player, GreedyString message) {
        String sourcePlayerName = PlayerHelper.getPlayerName((class_1657)player);
        String targetPlayerName = player2replyTargetPlayer.get(sourcePlayerName);
        try {
            CommandHelper.getCommandDispatcher().execute("msg %s %s".formatted(targetPlayerName, message.getValue()), (Object)player.method_64396());
            return 1;
        }
        catch (CommandSyntaxException e) {
            TextHelper.sendTextByKey(player, "reply.no_target", new Object[0]);
            return 0;
        }
    }

    @Document(id=1756134707146L, value="Set the reply target player.")
    @CommandNode(value="reply set-target")
    @CommandRequirement(level=4)
    private static int $setReplyTarget(@CommandSource class_3222 source, class_3222 target) {
        String sourceName = PlayerHelper.getPlayerName((class_1657)source);
        String targetName = PlayerHelper.getPlayerName((class_1657)target);
        ReplyInitializer.setReplyTarget(sourceName, targetName);
        return 1;
    }
}

