/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.core;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleLoadDeterminer;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@ColorBoxes(value={@ColorBox(id=1751870436910L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 How to use fuji?\n\nAll `modules` are `disabled` by default.\nYou can only enable the `interested modules`.\nModify the `config/fuji/config.json` file to `enable` a module.\nAfter that, `re-start` the server, to apply the `module enable status`.\n"), @ColorBox(id=1751870440489L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Does fuji support the `hot reload`?\n\nYes, fuji does support to `hot reload` the `files` from a `enabled module`.\nTo do that, just issue `/fuji reload`.\n\nHowever, you can't `enable` or `disable` a module when the server `is running`.\nThis is a design decision.\nFuji will `never load` a `disabled module` at all, for these considerations:\n1. For flexible, you can `disable any module` you don't like.\n2. If any other mods conflicts with `a module`, you can just `disable that module`.\n3. You only enable the `interested modules`, and there is no performance paying for `disabled module`.\n"), @ColorBox(id=1752891903903L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Adjust the `lore` text font size.\nIf the `lore` text is too large in your UI.\nYou can configure it in `Esc` - `Options` - `Video Settings` - `GUI Scale`\n\n\u25c9 Install the `client-side` mod to improve the displaying of `tooltip`.\nIf adjusting the `GUI Scale` option doesn't work well for you.\nYou can install the `ToolTipFix` mod to enhance the `tooltip` displaying.\n- https://modrinth.com/mod/tooltipfix\n- https://www.curseforge.com/minecraft/mc-mods/tooltipfix\n"), @ColorBox(id=1753331128791L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Use a `modern` text editor.\nThe most of `config files` are written in `json language`, and contains lots of lines.\nA `modern` text editor can `highlight` the structure of the file, and check the `syntax errors` for you.\nSo that you can `read` and `edit` the config files easier.\n\nHere are recommended text editors:\n1. Visual Studio Code: https://code.visualstudio.com/\n2. Vim: https://neovim.io/\n3. Emacs: https://www.gnu.org/software/emacs/\n"), @ColorBox(id=1753331405512L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Setup a `test server` in your `local machine`.\nYou may have a `remote machine` (Typically named `production server`) that is `running` and `hosting` your `Minecraft network`.\nHowever, it's strongly recommended to setup a `test server` in your `local machine`.\nThe `test server` should be a `mirror` of that `production server`.\nIt should contains the `mods` files and the `config files`.\n\nYou can modify and test new things in your `test server`.\nAfter everything is configured and working properly, you just upload the `mods` and `config files` into your `remote machine`.\n"), @ColorBox(id=1754014854649L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Open `this` GUI\nIssue: `/fuji`\n\n\u25c9 List all `fuji commands`\nIssue: `/fuji inspect fuji-commands`\n\n\u25c9 List all `fuji permissions` and `fuji metas`\nIssue: `/fuji inspect permissions-and-metas`\n\n\u25c9 List all `fuji placeholders`\nIssue: `/fuji inspect placeholders`\n\n\u25c9 List all `fuji configurations`\nIssue: `/fuji inspect configurations`\n\n\u25c9 List all `fuji jobs`\nIssue: `/fuji inspect jobs`\n\n\u25c9 List all `fuji languages`\nIssue: `/fuji inspect languages`\n\n\u25c9 List all `fuji argument types`\nIssue: `/fuji inspect argument-types`\n\n\u25c9 List all `fuji events`\nIssue: `/fuji inspect events`\n")})
public class CoreInitializer
extends ModuleInitializer {
    public static void printUserGuide() {
        String userGuide = " \u001b[2;35m\u001b[1;35m\n [Fuji User Guide]\u001b[0m\u001b[2;35m\n This is the user guide for new users.\n To disable this user guide, you can set `print_user_guide_in_console` in `config/fuji/config.json` to `false`.\n\n Here are some important points:\n - Fuji is designed to be fully-modular. \u001b[2;34mAll modules are disabled by default.\u001b[0m\u001b[2;35m\n - To enable a module: modify the `\u001b[2;34mconfig/fuji/config.json\u001b[0m\u001b[2;35m` file, and \u001b[2;34mre-start\u001b[0m\u001b[2;35m the server to apply the modification.\n     - To use `/tpa` command, enable the `tpa` module.\n     - To use placeholders provided by fuji, enable the `placeholder` module.\n     - To use echo commands like `/send-message`, `/send-broadcast` etc, enable the `echo` module.\n - To see the overview document, read the `fuji manual` pdf file in \u001b[2;34mhttps://github.com/sakurawald/fuji/raw/dev/docs/release/fuji.pdf\u001b[0m\u001b[2;35m\n - To discover new things, use `/fuji inspect` command.\n - Anything unclear, open an issue in \u001b[2;34mhttps://github.com/sakurawald/fuji/issues\u001b[0m\u001b[2;35m\u001b[0m\u001b[2;35m\n - Now, issue `\u001b[2;34m/fuji\u001b[0m\u001b[2;35m` to get started!\n\n \u001b[0m\n";
        LogUtil.info(userGuide, new Object[0]);
    }

    private static void tryPrintUserGuide() {
        if (Configs.MAIN_CONTROL_CONFIG.model().core.debug.print_user_guide_in_console) {
            CoreInitializer.printUserGuide();
        }
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void printModuleStatusReportOnServerStarted(@Unused ServerStartedEvent event) {
        List<String> enabledModuleList = ModuleLoadDeterminer.getEnabledModulePaths();
        LogUtil.info("Enabled {}/{} modules -> {}", enabledModuleList.size(), ModuleLoadDeterminer.MODULE_ENABLE_STATUS.size(), enabledModuleList);
        CoreInitializer.tryPrintUserGuide();
    }

    @NotNull
    public static String getModVersion() {
        return ServerHelper.getSelfModContainer().getMetadata().getVersion().getFriendlyString();
    }
}

