/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.deathlog.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import io.github.sakurawald.fuji.module.initializer.deathlog.DeathLogInitializer;
import io.github.sakurawald.fuji.module.initializer.deathlog.gui.DeathNodeListGui;
import io.github.sakurawald.fuji.module.initializer.deathlog.structure.DeathNode;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathDataListGui
extends PagedGui<String> {
    public DeathDataListGui(class_3222 player, @NotNull List<String> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "deathlog.death_data.list.gui.title", new Object[0]), entities, pageIndex);
    }

    public static boolean hasDeathData(class_3222 player, class_2487 root, String deadPlayerName) {
        if (root == null || root.method_33133()) {
            TextHelper.sendTextByKey(player, "deathlog.death_data.empty", deadPlayerName);
            return false;
        }
        return true;
    }

    @Override
    protected PagedGui<String> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<String> entities, int pageIndex) {
        return new DeathDataListGui(player, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull String entity) {
        GuiElementBuilder builder = (GuiElementBuilder)GuiHelper.Button.makeLuckyBlockButton().setName((class_2561)class_2561.method_43470((String)entity)).setCallback(() -> this.openDeathNodeListGui(entity));
        return builder.build();
    }

    @Override
    protected void drawPagedGui() {
        super.drawPagedGui();
        GuiHelper.PlayerSkull.fillPlayerHeadTextures((SlotGuiInterface)this);
    }

    private void openDeathNodeListGui(String entity) {
        NbtHelper.Storage.withNbtFile(DeathLogInitializer.getDeathDataPath(entity), root -> {
            if (!DeathDataListGui.hasDeathData(this.getPlayer(), root, entity)) {
                return;
            }
            class_2499 deathNodeList = NbtHelper.Walker.getOrCreateNbtElement(root, "Deaths", new class_2499());
            List<DeathNode> entries = deathNodeList.stream().map(it -> DeathNode.fromNbt((class_2487)it)).collect(Collectors.toList());
            Collections.reverse(entries);
            new DeathNodeListGui(this.getBackendGui(), this.getPlayer(), entity, entries, 0).open();
        });
    }
}

