/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.economy;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import io.github.sakurawald.fuji.module.initializer.economy.service.EconomyService;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EconomyPlaceholders {
    @DocStringProvider(id=1753668968954L, value="Returns the `balance` of the specified `currency` for the player.\n\nThe syntax is `%fuji:balance \\<currency-id\\>%`\nFor example, the `%fuji:balance fuji:gold%` will return the `balance` of the `fuji:gold` currency.\n\n\u25c9 Escape the placeholder properly.\n1. `/send-message %player:name% Your balance is %fuji:balance fuji:gold%`\n2. `/run as console send-message %player:name% Your balance is %fuji:balance fuji:gold%`\n\nTo prevent the placeholder being parsed by the `/run` command.\nYou need to insert a `backslash` character in case `2.` before the placeholder.\n")
    public static void registerBalancePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("balance", 1753668968954L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, (player, args) -> {
            GameProfile gameProfile = player.method_7334();
            Optional<class_2960> currencyId = RegistryHelper.makeIdentifier(args);
            return currencyId.map($currencyId -> {
                Optional<EconomyAccount> economyAccount = EconomyService.getUserAccount(gameProfile, $currencyId);
                return economyAccount.map(EconomyAccount::formattedBalance).orElseGet(() -> class_2561.method_43470((String)"[ECONOMY-ACCOUNT-NOT-FOUND-FOR-THIS-USER]"));
            }).orElse((class_2561)class_2561.method_43470((String)"[INVALID-CURRENCY-ID]"));
        });
    }
}

