/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AboutGui
extends PagedGui<Person> {
    public AboutGui(SimpleGui parent, class_3222 player, @NotNull List<Person> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "about", new Object[0]), entities, pageIndex);
        this.streamMessageIntoToast = false;
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("fuji").get()).getMetadata();
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 1, new GuiElementBuilder(class_1802.field_8529).setName(TextHelper.getTextByKey(player, "version.format", metadata.getVersion().getFriendlyString())));
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, (GuiElementBuilder)new GuiElementBuilder(class_1802.field_8137).setName(TextHelper.getTextByKey(player, "homepage.project", new Object[0])).setCallback(() -> {
            TextHelper.sendTextByKey(player, "homepage.project.visit", metadata.getContact().get("sources").orElse("can't read project homepage from metadata"));
            this.closeWithoutOpenParentGui();
        }));
    }

    public static AboutGui make(@Nullable SimpleGui parent, class_3222 player) {
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("fuji").orElseThrow(() -> new IllegalStateException("Failed to get the metadata of this mod."))).getMetadata();
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.addAll(metadata.getAuthors());
        persons.addAll(metadata.getContributors());
        return new AboutGui(parent, player, persons, 0);
    }

    @Override
    protected void drawPagedGui() {
        super.drawPagedGui();
        GuiHelper.PlayerSkull.fillPlayerHeadTextures((SlotGuiInterface)this);
    }

    @Override
    protected PagedGui<Person> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<Person> entities, int pageIndex) {
        return new AboutGui(parent, player, entities, pageIndex);
    }

    private boolean isUrl(String string) {
        return string.contains("http://") || string.contains("https://");
    }

    public GuiElementInterface.ClickCallback makeCallback(Person entity) {
        return (a, b, c, d) -> {
            class_5250 text = class_2561.method_43473();
            text.method_10852(TextHelper.getTextByKey(this.getPlayer(), "contact.visit.name", entity.getName())).method_10852(TextHelper.TEXT_NEWLINE);
            entity.getContact().asMap().forEach((k, v) -> text.method_10852(TextHelper.getTextByKey(this.getPlayer(), this.isUrl((String)v) ? "contact.visit.entry.is_url" : "contact.visit.entry.is_not_url", k, v, v)).method_10852(TextHelper.TEXT_NEWLINE));
            TextHelper.sendMessageByText(this.getPlayer(), (class_2561)text);
            this.closeWithoutOpenParentGui();
        };
    }

    public List<class_2561> makeTextListFromContact(ContactInformation contact) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        contact.asMap().forEach((k, v) -> ret.add(TextHelper.getTextByKey(this.getPlayer(), "contact.entry", k, v)));
        ret.add(TextHelper.getTextByKey(this.getPlayer(), "contact.click.prompt", new Object[0]));
        return ret;
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull Person entity) {
        return GuiHelper.Button.makeLuckyBlockButton().setName(TextHelper.getTextByKey(this.getPlayer(), "contact.name", entity.getName())).setLore(this.makeTextListFromContact(entity.getContact())).setCallback(this.makeCallback(entity)).build();
    }
}

