/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.fuji.structure;

import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectingObject {
    public final Object object;
    @Nullable
    public final Object instanceOfField;
    @Nullable
    public final String preferredObjectName;

    public InspectingObject(Object object, @Nullable Object instanceOfField, @Nullable String preferredObjectName) {
        this.object = object;
        this.instanceOfField = instanceOfField;
        this.preferredObjectName = preferredObjectName;
    }

    public boolean canGoInside() {
        Class<?> type = this.getObjectType();
        if (type.isPrimitive()) {
            return false;
        }
        if (ReflectionUtil.isPrimitiveWrapperType(type)) {
            return false;
        }
        if (type.equals(String.class)) {
            return false;
        }
        if (type.isArray()) {
            return false;
        }
        if (type.isEnum()) {
            return false;
        }
        return !type.isAnnotation();
    }

    public Class<?> getObjectType() {
        Object object = this.object;
        if (object instanceof Field) {
            Field field = (Field)object;
            return field.getType();
        }
        return this.object.getClass();
    }

    private String getObjectValueReadableString() {
        Object value = this.getObjectValue();
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return "%d elements".formatted(collection.size());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return "%d elements".formatted(map.size());
        }
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            String keyTypeString = entry.getKey().getClass().getSimpleName();
            String valueTypeString = entry.getValue().getClass().getSimpleName();
            return "mapper %s -> %s".formatted(keyTypeString, valueTypeString);
        }
        return String.valueOf(value);
    }

    @Nullable
    public String getDocumentString(class_3222 player) {
        Object object = this.object;
        if (object instanceof Field) {
            Field field = (Field)object;
            return DocumentUtil.getFieldDocumentString(player, field);
        }
        Class<?> objectType = this.getObjectType();
        String classDocument = DocumentUtil.getClassDocumentString(player, objectType);
        return classDocument;
    }

    public Object getObjectValue() {
        Object object = this.object;
        if (object instanceof Field) {
            Object value;
            Field field = (Field)object;
            try {
                field.setAccessible(true);
                value = field.get(this.instanceOfField);
            }
            catch (Exception e) {
                value = "FAILED-TO-ACCESS";
            }
            return value;
        }
        return this.object;
    }

    private boolean isFieldType() {
        return this.object instanceof Field;
    }

    public String getObjectName() {
        if (this.preferredObjectName != null) {
            return this.preferredObjectName;
        }
        Object objectName = this.isFieldType() ? ((Field)this.object).getName() : this.object.getClass().getSimpleName();
        if (!this.isFieldType()) {
            objectName = "$" + (String)objectName;
        }
        return objectName;
    }

    public class_2561 computeNameText(class_3222 player) {
        String objectName = this.getObjectName();
        objectName = TextHelper.Parsers.escapeTags(objectName);
        return TextHelper.getTextByKey(player, "object.name", objectName);
    }

    private static List<Field> gatherDeclaredFieldsRecursively(List<Field> result, Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        result.addAll(Arrays.asList(declaredFields));
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != Object.class) {
            InspectingObject.gatherDeclaredFieldsRecursively(result, superclass);
        }
        return result;
    }

    private static List<Field> gatherDeclaredFields(Class<?> clazz) {
        ArrayList<Field> allDeclaredFields = new ArrayList<Field>();
        InspectingObject.gatherDeclaredFieldsRecursively(allDeclaredFields, clazz);
        return allDeclaredFields;
    }

    public static List<InspectingObject> inspectJavaObject(@NotNull Object object) {
        if (object instanceof InspectingObject) {
            object = ((InspectingObject)object).object;
        }
        Object fieldInstance = object;
        Class<?> inspectingObjectClass = object.getClass();
        return InspectingObject.gatherDeclaredFields(inspectingObjectClass).stream().filter(field -> {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) {
                return false;
            }
            return !Modifier.isTransient(modifiers);
        }).map(it -> new InspectingObject(it, fieldInstance, null)).toList();
    }

    public class_1792 computeItem() {
        Class<?> type = this.getObjectType();
        if (Map.class.isAssignableFrom(type)) {
            return class_1802.field_8895;
        }
        if (Iterable.class.isAssignableFrom(type)) {
            return class_1802.field_23983;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            Boolean booleanValue = (Boolean)this.getObjectValue();
            return booleanValue != false ? class_1802.field_8295 : class_1802.field_8586;
        }
        if (String.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) {
            return class_1802.field_8276;
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return class_1802.field_8725;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return class_1802.field_8601;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return class_1802.field_8619;
        }
        return class_1802.field_8520;
    }

    private void addPossibleValuesForEnumType(class_3222 player, List<class_2561> lore) {
        if (!this.getObjectType().isEnum()) {
            return;
        }
        String possibleValues = ReflectionUtil.getEnumValuesCompactString(this.getObjectType());
        lore.add(TextHelper.getTextByKey(player, "object.value.possible_values", possibleValues));
    }

    public List<class_2561> computeLore(class_3222 player) {
        String documentString;
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        String objectTypeString = this.getObjectTypeString();
        lore.add(TextHelper.getTextByKey(player, "object.type", objectTypeString));
        String literalObjectValueString = this.getObjectValueString(true);
        lore.add(TextHelper.getText(TextHelper.Parsers.STYLE_ONLY_PARSER, player, true, "object.value", literalObjectValueString));
        this.addPossibleValuesForEnumType(player, lore);
        if (this.canGoInside()) {
            lore.add(TextHelper.getTextByKey(player, "prompt.click.see_inside", new Object[0]));
        }
        if ((documentString = this.getDocumentString(player)) != null) {
            lore.add(TextHelper.TEXT_EMPTY);
            lore.addAll(TextHelper.getDocumentTextList(player, documentString));
        }
        return lore;
    }

    @NotNull
    public String getObjectValueString(boolean abbreviated) {
        String literalObjectValueString = this.getObjectValueReadableString();
        if (abbreviated) {
            literalObjectValueString = StringUtils.abbreviate((String)literalObjectValueString, (String)"...", (int)128);
        }
        literalObjectValueString = TextHelper.Parsers.escapeTags(literalObjectValueString);
        return literalObjectValueString;
    }

    @NotNull
    private String getObjectTypeString() {
        return this.getObjectType().getName();
    }

    @Generated
    public Object getObject() {
        return this.object;
    }

    @Nullable
    @Generated
    public Object getInstanceOfField() {
        return this.instanceOfField;
    }

    @Nullable
    @Generated
    public String getPreferredObjectName() {
        return this.preferredObjectName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InspectingObject)) {
            return false;
        }
        InspectingObject other = (InspectingObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Object this$instanceOfField = this.getInstanceOfField();
        Object other$instanceOfField = other.getInstanceOfField();
        if (this$instanceOfField == null ? other$instanceOfField != null : !this$instanceOfField.equals(other$instanceOfField)) {
            return false;
        }
        String this$preferredObjectName = this.getPreferredObjectName();
        String other$preferredObjectName = other.getPreferredObjectName();
        return !(this$preferredObjectName == null ? other$preferredObjectName != null : !this$preferredObjectName.equals(other$preferredObjectName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InspectingObject;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Object $instanceOfField = this.getInstanceOfField();
        result = result * 59 + ($instanceOfField == null ? 43 : $instanceOfField.hashCode());
        String $preferredObjectName = this.getPreferredObjectName();
        result = result * 59 + ($preferredObjectName == null ? 43 : $preferredObjectName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InspectingObject(object=" + String.valueOf(this.getObject()) + ", instanceOfField=" + String.valueOf(this.getInstanceOfField()) + ", preferredObjectName=" + this.getPreferredObjectName() + ")";
    }
}

