/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.gameplay.multi_obsidian_platform;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.gameplay.multi_obsidian_platform.config.model.MultiObsidianPlatformConfigModel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;

@Document(id=1751827009997L, value="This module makes every `ender portal frame` generates its own `obsidian platform`.\n")
@ColorBox(id=1751976988699L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 All the obsidian platforms are vanilla-respect.\nThat's to say, all the additional `obsidian platforms` have the `identical` behaviour as the vanilla one, which locates in (100, 50, 0).\n\n\u25c9 A well-known feature if you create the `Ender Portal` in the nether.\nSee https://bugs.mojang.com/browse/MC-252361\n")
public class MultiObsidianPlatformInitializer
extends ModuleInitializer {
    private static final Map<class_2338, class_2338> TRANSFORM_CACHE = new ConcurrentHashMap<class_2338, class_2338>();
    private static final BaseConfigurationHandler<MultiObsidianPlatformConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", MultiObsidianPlatformConfigModel.class);

    private static class_2338 findNearbyEndPortalBlock(@NotNull class_2338 bp) {
        class_3218 overworld = ServerHelper.getServer().method_30002();
        if (overworld.method_8320(bp) == class_2246.field_10027.method_9564()) {
            return bp;
        }
        int searchRadius = 3;
        for (int y = -searchRadius; y < searchRadius; ++y) {
            for (int x = -searchRadius; x < searchRadius; ++x) {
                for (int z = -searchRadius; z < searchRadius; ++z) {
                    class_2338 test = bp.method_10069(x, y, z);
                    if (overworld.method_8320(test) != class_2246.field_10027.method_9564()) continue;
                    return test;
                }
            }
        }
        LogUtil.warn("the BlockPos {} is not END_PORTAL and we can't find a nearby END_PORTAL block !", bp);
        return bp;
    }

    private static class_2338 findCenterEndPortalBlock(@NotNull class_2338 bp) {
        class_3218 overworld = ServerHelper.getServer().method_30002();
        if (overworld.method_8320(bp.method_10095()) != class_2246.field_10027.method_9564()) {
            if (overworld.method_8320(bp.method_10067()) != class_2246.field_10027.method_9564()) {
                return bp.method_10072().method_10078();
            }
            if (overworld.method_8320(bp.method_10078()) != class_2246.field_10027.method_9564()) {
                return bp.method_10072().method_10067();
            }
            return bp.method_10072();
        }
        if (overworld.method_8320(bp.method_10072()) != class_2246.field_10027.method_9564()) {
            if (overworld.method_8320(bp.method_10067()) != class_2246.field_10027.method_9564()) {
                return bp.method_10095().method_10078();
            }
            if (overworld.method_8320(bp.method_10078()) != class_2246.field_10027.method_9564()) {
                return bp.method_10095().method_10067();
            }
            return bp.method_10095();
        }
        if (overworld.method_8320(bp.method_10067()) != class_2246.field_10027.method_9564()) {
            return bp.method_10078();
        }
        if (overworld.method_8320(bp.method_10078()) != class_2246.field_10027.method_9564()) {
            return bp.method_10067();
        }
        return bp;
    }

    public static class_2338 getTransformedEndSpawnPosition(class_2338 enderPortalFrameBlockPos) {
        if (TRANSFORM_CACHE.containsKey(enderPortalFrameBlockPos)) {
            return TRANSFORM_CACHE.get(enderPortalFrameBlockPos);
        }
        enderPortalFrameBlockPos = MultiObsidianPlatformInitializer.findNearbyEndPortalBlock(enderPortalFrameBlockPos);
        enderPortalFrameBlockPos = MultiObsidianPlatformInitializer.findCenterEndPortalBlock(enderPortalFrameBlockPos);
        double factor = MultiObsidianPlatformInitializer.config.model().factor;
        int x = (int)((double)enderPortalFrameBlockPos.method_10263() / factor);
        int y = 50;
        int z = (int)((double)enderPortalFrameBlockPos.method_10260() / factor);
        int x_offset = x % 16;
        int z_offset = z % 16;
        x -= x_offset;
        TRANSFORM_CACHE.put(enderPortalFrameBlockPos, new class_2338(x += 100, y, z -= z_offset));
        return TRANSFORM_CACHE.get(enderPortalFrameBlockPos);
    }

    @Override
    protected void onReload() {
        TRANSFORM_CACHE.clear();
    }
}

