/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.home.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.ConfirmSignGui;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.home.service.HomeService;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListHomesGui
extends PagedGui<GlobalPos> {
    private final String targetPlayerName;

    private ListHomesGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull String targetPlayerName, @NotNull List<GlobalPos> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "home.list.gui.title", targetPlayerName), entities, pageIndex);
        this.targetPlayerName = targetPlayerName;
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "home.list.gui.help.lore")));
    }

    public static ListHomesGui make(@NotNull class_3222 player, @NotNull String targetPlayerName) {
        List<GlobalPos> entities = HomeService.withHomeMap(targetPlayerName).values().stream().toList();
        return new ListHomesGui(null, player, targetPlayerName, entities, 0);
    }

    @Override
    protected PagedGui<GlobalPos> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<GlobalPos> entities, int pageIndex) {
        return new ListHomesGui(parent, player, this.targetPlayerName, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull GlobalPos entity) {
        final String homeName = (String)HomeService.withHomeMap(this.targetPlayerName).inverse().get((Object)entity);
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.addAll(entity.asLore(this.player));
        lore.add(TextHelper.getTextByKey(this.player, "prompt.click.teleport", new Object[0]));
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8417).setName((class_2561)class_2561.method_43470((String)homeName)).setLore(lore).setCallback(clickType -> {
            if (clickType.isLeft) {
                entity.teleport(this.player);
                this.close();
                return;
            }
            if (clickType.isRight) {
                new ConfirmSignGui(this.player){

                    @Override
                    public void onConfirm() {
                        HomeService.removeHome(ListHomesGui.this.targetPlayerName, homeName);
                        TextHelper.sendTextByKey(this.player, "home.unset.success", homeName);
                    }

                    @Override
                    protected void onConfirmedOrCancelled() {
                        ListHomesGui.this.getBackendGui().open();
                    }
                }.open();
                return;
            }
        })).build();
    }
}

