/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.jail;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.ModifyPlayerDisplayNameEvent;
import io.github.sakurawald.fuji.core.event.message.player.ModifyPlayerListNameEvent;
import io.github.sakurawald.fuji.core.service.duration_parser.command.argument.wrapper.Duration;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.jail.JailPlaceholders;
import io.github.sakurawald.fuji.module.initializer.jail.command.argument.wrapper.JailedPlayerName;
import io.github.sakurawald.fuji.module.initializer.jail.config.model.JailConfigModel;
import io.github.sakurawald.fuji.module.initializer.jail.config.model.JailDataModel;
import io.github.sakurawald.fuji.module.initializer.jail.gui.JailListGui;
import io.github.sakurawald.fuji.module.initializer.jail.job.PatrolJailJob;
import io.github.sakurawald.fuji.module.initializer.jail.service.JailService;
import io.github.sakurawald.fuji.module.initializer.jail.structure.JailDescriptor;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Document(id=1753681022357L, value="This module allows you to define a `jail`.\nIt can be used to `punish` a player with bad behaviour, without `banning` it.\n")
@ColorBoxes(value={@ColorBox(id=1753757093710L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n1. Each `jail descriptor` is used to define a `jail` instance.\n1.a. You can `create` a descriptor using the `/jail create` command.\n1.b. You can `delete` a descriptor using the `/jail delete` command.\n1.c. You can `list` all created descriptors using the `/jail list` command.\n2. Each `jail` can hold `more than 1 player`.\n2.a. Each `jailed player` is recorded with a `jail record`.\n2.b. A `player` can only be put in one `jail` at a time.\n3. Each `jail` has a `position` property.\n3.a. It's `initialized` to your current position when you run the `/jail create` command.\n3.b. You can set a new position for it using `/jail set-position` command.\n3.c. You can teleport to the position using `/jail tp` command.\n4. You can `put` a `player` into a `jail`, or `un-put` it.\n4.a. To `put`, use `/jail put` command.\n4.b. To `un-put`, use `/jail un-put` command.\n4.c. To query the info, use `/jail where` command.\n\n\u25c9 The difference between `banned players` and `jailed players`.\n1. For a `banned players`: They can't `join` the server.\n2. For a `jailed players`: They can `join` the server.\n\n<green> NOTE: A `jail` is only used to hold information.\n<green> You need to write `punishment commands` in `onJailedEvent` and `onUnjailedEvent`.\n<green> You can also write `patrol commands` to check and restrict the actions of the jailed players.\n"), @ColorBox(id=1753774841738L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The `placeholders` to the `position` of a `jail`.\n1. `%fuji:jail_dimension%`\n2. `%fuji:jail_x%`\n3. `%fuji:jail_y%`\n4. `%fuji:jail_z%`\n5. `%fuji:jail_yaw%`\n6. `%fuji:jail_pitch%`\n\n\u25c9 Restrict the `movement` of `jailed players` within a specified area.\nWith the help of `position placeholders`, you can write `patrol commands` to restrict movements.\nYou can define commands to restrict the movement of jailed players within a specified area.\n1. `/execute as %player:name% at @s unless dimension %fuji:jail_dimension% run execute in %fuji:jail_dimension% run tp @s %fuji:jail_x% %fuji:jail_y% %fuji:jail_z%`\n2. `/execute as %player:name% if entity @s[x=%fuji:jail_x%,y=%fuji:jail_y%,z=%fuji:jail_z%,distance=8..] run tp @s %fuji:jail_x% %fuji:jail_y% %fuji:jail_z%`\n\n<green>NOTE: If you have enabled the `teleport_warmup` module, remember to assign the `warmup bypass` permission for the `jailed` user group.\n<green>So that `jailed players` can be `instantly` teleported back to the `position of the jail`.\n1. `/lp group jailed permission set fuji.teleport_warmup.bypass`\n\n<green>NOTE: To disable the `vanilla Minecraft command feedbacks`, you can issue:\n1. `/gamerule sendCommandFeedback false`\n"), @ColorBox(id=1753750852480L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Understand the `execution time` of a `command`.\nSome commands require the `target player` online to work.\nFor example, the `/send-message %player:name% You are jailed.` didn't work if the target player is `off-line`.\nIn this case, you can use the `command_meta.when_online` module, to submit and schedule a command.\nIssue: `/when-online %player:name% send-message %player:name% You are jailed.`\n\n\u25c9 Create a `luckperms group` for `jailed players`.\nYou can create a `luckperms group` for `jailed players`.\nAnd assign the `positive permissions` and `negative permissions` to `jailed players`.\nUse the `permissions` to control the behaviours of `jailed players`.\n\n\u25c9 Restrict the actions of `jailed players`.\nYou can integrate with the `anti_build` module.\nTo assign `negative permissions` to `jailed user group`, to limit the actions of them.\nIssue:\n1. `/lp group jailed permission set fuji.anti_build.break_block.override.* false`\n2. `/lp group jailed permission set fuji.anti_build.place_block.override.* false`\n3. `/lp group jailed permission set fuji.anti_build.interact_item.override.* false`\n4. `/lp group jailed permission set fuji.anti_build.interact_entity.override.* false`\n5. `/lp group jailed permission set fuji.anti_build.interact_block.override.* false`\n<green>NOTE: You need to enable the `wildcard permission` feature in `luckperms` mod config.\n"), @ColorBox(id=1754329012853L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Restrict `jailed players` to using only allowed commands.\nYou can integrate with `command_permission` module.\nIssue:\n1. `/lp group jailed permission set fuji.permission.* false`\nDis-allow to use `all commands`.\n\n2. `/lp group jailed permission set fuji.permission.back true`\nAllow to use the `/back` command.\n"), @ColorBox(id=1753780761908L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a `jail` in your current position.\nIssue: `/jail create \\<jail-id\\>`\n\n\u25c9 Set the position of a jail to your current position.\nIssue: `/jail set-position \\<jail-id\\>`\n\n\u25c9 Teleport to the position of a jail.\nIssue: `/jail tp \\<jail-id\\>`\n\n\u25c9 List all created jails.\nIssue: `/jail list`\n\n\u25c9 Put a player into a jail.\nIssue:\n1. `/jail put Steve \\<jail-id\\> Steal items.`\n2. `/jail put Steve \\<jail-id\\> --duration 1s2m3h4d5w6M7y Steal items.`\n\n\u25c9 Un-put a player from the jail.\nIssue: `/jail unput Steve`\n\n\u25c9 Query which jail a player is in.\nIssue: `/jail where Steve`\n")})
public class JailInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<JailConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", JailConfigModel.class);
    public static final BaseConfigurationHandler<JailDataModel> data = ObjectConfigurationHandler.ofModule("jail-data.json", JailDataModel.class).enableAutoSaveFeature();

    @Document(id=1753686048373L, value="List all defined `jails`.")
    @CommandNode(value="jail list")
    @CommandRequirement(level=4)
    private static int $list(@CommandSource class_2168 source) {
        TextHelper.sendTextByKey(source, "jail.list", JailService.getJailIds());
        return 1;
    }

    @Document(id=1753686063844L, value="Put the `player` into a specified `jail`.")
    @CommandNode(value="jail put")
    @CommandRequirement(level=4)
    private static int $put(@CommandSource class_2168 source, OfflinePlayerName playerName, JailDescriptor jail, Optional<Duration> duration, GreedyString reason) {
        String creatorName = source.method_9214();
        String $playerName = (String)playerName.getValue();
        String $reason = (String)reason.getValue();
        String $duration = (String)duration.orElseGet(() -> new Duration(jail.getDefaultJailedDuration())).getValue();
        return JailService.getActiveJailRecord($playerName).map(activeJailRecord -> {
            TextHelper.sendTextByKey(source, "jail.already_in_jail", $playerName, jail.getId());
            return 0;
        }).orElseGet(() -> {
            try {
                JailService.createJailRecord(creatorName, $playerName, jail, $reason, $duration);
                TextHelper.sendTextByKey(source, "jail.put", $playerName, jail.getId());
            }
            catch (Exception e) {
                TextHelper.sendTextByKey(source, "jail.put.failed", $playerName);
                JailService.deactivateJailRecordWithoutEvents($playerName);
            }
            return 1;
        });
    }

    @Document(id=1753690598413L, value="Remove a player from the jail it is currently in.")
    @CommandNode(value="jail un-put")
    @CommandRequirement(level=4)
    private static int $unPut(@CommandSource class_2168 source, JailedPlayerName playerName) {
        String $playerName = (String)playerName.getValue();
        return JailService.getActiveJailRecord($playerName).map(activeJailRecord -> {
            JailService.deactivateJailRecord(activeJailRecord);
            TextHelper.sendTextByKey(source, "jail.unput", $playerName, activeJailRecord.getOwnerJailDescriptor().getId());
            return 1;
        }).orElseGet(() -> {
            TextHelper.sendTextByKey(source, "jail.not_in_jail", $playerName);
            return 0;
        });
    }

    @Document(id=1753692574518L, value="Find the `jail` the player is in.")
    @CommandNode(value="jail where")
    @CommandRequirement(level=4)
    private static int $where(@CommandSource class_2168 source, JailedPlayerName playerName) {
        String $playerName = (String)playerName.getValue();
        return JailService.getActiveJailRecord($playerName).map(jailRecord -> {
            JailDescriptor ownerJailDescriptor = jailRecord.getOwnerJailDescriptor();
            TextHelper.sendTextByKey(source, "line.separator", new Object[0]);
            TextHelper.sendTextByKey(source, "jail.record.prisoner_name", $playerName);
            TextHelper.sendTextByKey(source, "jail.record.creator_name", jailRecord.getCreatorName());
            TextHelper.sendTextByKey(source, "jail.record.created_time", jailRecord.getFormattedCreatedTimestamp());
            TextHelper.sendTextByKey(source, "jail.record.jail_id", ownerJailDescriptor.getId());
            TextHelper.sendTextByKey(source, "jail.record.specified_jail_duration", jailRecord.getSpecifiedJailDuration());
            TextHelper.sendTextByKey(source, "jail.record.remaining_jail_duration", jailRecord.getRemainingJailDuration());
            TextHelper.sendTextByKey(source, "jail.record.reason", TextHelper.Parsers.escapeTags(jailRecord.getReason()));
            return 1;
        }).orElseGet(() -> {
            TextHelper.sendTextByKey(source, "jail.not_in_jail", $playerName);
            return 0;
        });
    }

    @Document(id=1753771412507L, value="A predicate command to check if the target player is jailed.")
    @CommandNode(value="is-jailed?")
    @CommandRequirement(level=4)
    private static int $isJailed(@CommandSource class_2168 source, String playerName) {
        return CommandHelper.Return.returnBoolean(source, JailService.getActiveJailRecord(playerName).isPresent());
    }

    @Document(id=1753772112918L, value="Create a new `jail` descriptor.")
    @CommandNode(value="jail create")
    @CommandRequirement(level=4)
    private static int $create(@CommandSource class_2168 source, String jailId) {
        return JailService.findJailDescriptor(jailId).map(it -> {
            TextHelper.sendTextByKey(source, "jail.already_exists", jailId);
            return 0;
        }).orElseGet(() -> {
            JailService.createJailDescriptor(jailId, source);
            TextHelper.sendTextByKey(source, "jail.create.success", jailId);
            return 1;
        });
    }

    @Document(id=1753772960860L, value="Delete an existing `jail` descriptor")
    @CommandNode(value="jail delete")
    @CommandRequirement(level=4)
    private static int $deleteJail(@CommandSource class_2168 source, JailDescriptor jail, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            JailService.deleteJailDescriptor(jail);
            TextHelper.sendTextByKey(source, "jail.delete.success", jail.getId());
            return 1;
        });
    }

    @Document(id=1753774327312L, value="Teleport to the `position` of an existing `jail`.")
    @CommandNode(value="jail tp")
    @CommandRequirement(level=4)
    private static int $tp(@CommandSource @CommandTarget class_3222 player, JailDescriptor jail) {
        jail.getGlobalPosition().teleport(player);
        TextHelper.sendTextByKey(player, "jail.tp", jail.getId());
        return 1;
    }

    @Document(id=1753774502626L, value="Set the `position` of the specified `jail` to your current position.")
    @CommandNode(value="jail set-position")
    @CommandRequirement(level=4)
    private static int $setPosition(@CommandSource class_3222 player, JailDescriptor jail) {
        GlobalPos newValue = GlobalPos.of(player);
        JailService.setJailPosition(jail, newValue);
        TextHelper.sendTextByKey(player, "jail.set_position", jail.getId());
        return 1;
    }

    @Document(id=1753864337061L, value="Open the jail GUI.")
    @CommandNode(value="jail gui")
    @CommandRequirement(level=4)
    private static int $gui(@CommandSource class_3222 player) {
        JailListGui.make(player).open();
        return 1;
    }

    @Override
    protected void onInitialize() {
        PatrolJailJob.reloadPatrolJobs();
    }

    @Override
    protected void onReload() {
        PatrolJailJob.reloadPatrolJobs();
    }

    @Override
    protected void registerPlaceholders() {
        JailPlaceholders.registerJailIdPlaceholder();
        JailPlaceholders.registerJailDisplayNamePlaceholder();
        JailPlaceholders.registerJailCreatorNamePlaceholder();
        JailPlaceholders.registerJailCreatedDatePlaceholder();
        JailPlaceholders.registerJailSpecifiedJailDurationPlaceholder();
        JailPlaceholders.registerJailRemainingJailDurationPlaceholder();
        JailPlaceholders.registerJailReasonPlaceholder();
        JailPlaceholders.registerJailDimensionPlaceholder();
        JailPlaceholders.registerJailXPlaceholder();
        JailPlaceholders.registerJailYPlaceholder();
        JailPlaceholders.registerJailZPlaceholder();
        JailPlaceholders.registerJailYawPlaceholder();
        JailPlaceholders.registerJailPitchPlaceholder();
    }

    @EventConsumer(injectorPriority=2000)
    private static void modifyPlayerListName(ModifyPlayerListNameEvent event) {
        class_3222 player = event.getPlayer();
        class_2561 original = event.getText();
        class_2561 newValue = JailService.modifyDisplayName(original, (class_1657)player);
        event.setText(newValue);
    }

    @EventConsumer(injectorPriority=2000)
    private static void modifyPlayerDisplayName(ModifyPlayerDisplayNameEvent event) {
        class_1657 player = event.getPlayer();
        class_2561 original = event.getText();
        class_2561 newValue = JailService.modifyDisplayName(original, player);
        event.setText(newValue);
    }
}

