/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.kit;

import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.core.document.annotation.TestCases;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.kit.command.argument.wrapper.KitName;
import io.github.sakurawald.fuji.module.initializer.kit.gui.KitEditorGui;
import io.github.sakurawald.fuji.module.initializer.kit.gui.KitPreviewGui;
import io.github.sakurawald.fuji.module.initializer.kit.service.KitService;
import io.github.sakurawald.fuji.module.initializer.kit.structure.Kit;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751824812720L, value="Make a set of `item stacks` as a `kit`, and give the kit to players.\n")
@ColorBoxes(value={@ColorBox(id=1751977591928L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a kit.\nIssue: `/kit editor` to create a new `kit`.\n\n\u25c9 Give a kit to a player.\nIssue: `/kit give Alice \\<kit-name\\>` to give a `kit` to a player.\n\n\u25c9 Create a user-level command, for players to `claim a kit`.\n<red>The `/kit give` command is a `admin-level` command, you should NOT allow players to use it directly.\n<green>TIP: You need to use `command_bundle` module to create a new `user-level` command, for players to `claim a kit`.\n"), @ColorBox(id=1751977756034L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Associate a cooldown to a kit.\nYou can use `command_cooldown` module, to create a `named cooldown` for the `kit claim command`.\n\nTo create a `named cooldown`\nIssue: `/command-cooldown create example-kit-cooldown 60000`\n\nTo test the cooldown, and give the kit if the cooldown is satisfied.\nIssue: `/command-cooldown test example-kit-cooldown Alice --onFailed \"send-message %player:name% wait a moment\" kit give %player:name% example-kit|send-message %player:name% kit received.`\n"), @ColorBox(id=1751977848415L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Claim a specific kit automatically for online players.\nYou can use `command_scheduler` module, to execute the `kit claim command` for online players automatically every minute.\n"), @ColorBox(id=1751977880532L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Give the new-bie player a kit.\nYou can use `command_event` module, to give a kit to the new-bie player.\n"), @ColorBox(id=1756110650928L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Make a GUI to display all available kits.\nYou can integrate with the `command_menu` module.\nTo create a `menu` to `display` available kits, making it easier to `claim` a `kit`.\n\n\u25c9 Attach the kit claim command to objects.\nYou can integrate with `command_attachment` module.\nTo attach the kit claim command to a `block`, `entity` or `item`.\n")})
@CommandNode(value="kit")
@CommandRequirement(level=4)
@TestCases(value={@TestCase(action="Create a new kit using `/kit editor` command.", targets={"See if the `kit editor` works."}), @TestCase(action="Give the new kit using `/kit give` command.", targets={"See if the items is inserted in the proper slots. (Note that the player in creative mode can always pick up the same items even their inventory is full.)"})})
public class KitInitializer
extends ModuleInitializer {
    @Document(id=1751824817401L, value="Open the kit editor GUI.")
    @CommandNode(value="editor")
    private static int $editor(@CommandSource class_3222 player) {
        KitEditorGui.make(player).open();
        return 1;
    }

    @Document(id=1751824821391L, value="Give the kit to the player.")
    @CommandNode(value="give")
    private static int $give(@CommandSource class_2168 source, class_3222 player, KitName kit) {
        Kit kitInstance = KitService.readKit((String)kit.getValue());
        KitService.giveKit(player, kitInstance);
        return 1;
    }

    @Document(id=1756372814981L, value="Open a GUI to pre-view the specified kit.")
    @CommandNode(value="preview")
    private static int $preview(@CommandSource class_2168 source, class_3222 player, KitName kit) {
        Kit $kit = KitService.readKit((String)kit.getValue());
        KitPreviewGui.make(player, $kit).open();
        return 1;
    }

    @Override
    protected void onInitialize() {
        KitService.createKitDirectory();
    }
}

