/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.leaderboard;

import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import io.github.sakurawald.fuji.module.initializer.leaderboard.service.LeaderBoardService;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardArgumentsParseResult;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardDescriptor;
import io.github.sakurawald.fuji.module.initializer.leaderboard.structure.LeaderBoardTimeWindow;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;

public class LeaderBoardPlaceholders {
    @DocStringProvider(id=1753468955141L, value="Returns the `lowest N` player name of specified `leaderboard id`.\n\nThe syntax is `%fuji:lowest_n_name \\<leaderboard-id\\> \\<n\\> \\<time-window\\>`\nThe `time window` can be `hourly`, `daily`, `weekly`, `monthly`, `yearly` and `all_time`.\n\nFor example:\nThe `%fuji:lowest_n_name death-board 1 all_time%` returns `the name of the player with the least number of death` from the leaderboard with the id `death-board`.\n")
    public static void registerLowestNPlayerNamePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("lowest_n_name", 1753468955141L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            LeaderBoardArgumentsParseResult result = LeaderBoardPlaceholders.verifyRankNArguments(args);
            if (result.getErrorText() != null) {
                return result.getErrorText();
            }
            return LeaderBoardService.getLowestN(result.getLeaderBoardDescriptor(), result.getRankN(), result.getTimeWindow()).map(it -> class_2561.method_30163((String)it.getOwnerCache().getPlayerName())).orElseGet(LeaderBoardService::getNonePlayerText);
        });
    }

    @DocStringProvider(id=1753471573263L, value="Returns the `lowest N` score of specified `leaderboard id`.\n\nThe syntax is `%fuji:lowest_n_score \\<leaderboard-id\\> \\<n\\> \\<time-window\\>`\nThe `time window` can be `hourly`, `daily`, `weekly`, `monthly`, `yearly` and `all_time`.\n\nFor example:\nThe `%fuji:lowest_n_score death-board 1 all_time%` returns the `the least number of death score` from the leaderboard with the id `death-board`.\n")
    public static void registerLowestNScorePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("lowest_n_score", 1753471573263L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            LeaderBoardArgumentsParseResult result = LeaderBoardPlaceholders.verifyRankNArguments(args);
            if (result.getErrorText() != null) {
                return result.getErrorText();
            }
            return LeaderBoardService.getLowestN(result.getLeaderBoardDescriptor(), result.getRankN(), result.getTimeWindow()).map(it -> class_2561.method_30163((String)String.valueOf(it.getEffectiveScore()))).orElseGet(LeaderBoardService::getNoScoreText);
        });
    }

    @DocStringProvider(id=1753476135481L, value="Returns the `highest N` player name of specified `leaderboard id`.\n\nThe syntax is `%fuji:highest_n_name \\<leaderboard-id\\> \\<n\\> \\<time-window\\>`\nThe `time window` can be `hourly`, `daily`, `weekly`, `monthly`, `yearly` and `all_time`.\n\nFor example:\nThe `%fuji:highest_n_name zombie-kill-board 1 all_time%` returns `the name of the player with the highest number of zombie kills` from the leaderboard with the id `zombie-kill-board`.\n")
    public static void registerHighestNPlayerNamePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("highest_n_name", 1753476135481L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            LeaderBoardArgumentsParseResult result = LeaderBoardPlaceholders.verifyRankNArguments(args);
            if (result.getErrorText() != null) {
                return result.getErrorText();
            }
            return LeaderBoardService.getHighestN(result.getLeaderBoardDescriptor(), result.getRankN(), result.getTimeWindow()).map(it -> class_2561.method_30163((String)it.getOwnerCache().getPlayerName())).orElseGet(LeaderBoardService::getNonePlayerText);
        });
    }

    @DocStringProvider(id=1753476193458L, value="Returns the `highest N` score of specified `leaderboard id`.\n\nThe syntax is `%fuji:highest_n_score \\<leaderboard-id\\> \\<n\\> \\<time-window\\>`\nThe `time window` can be `hourly`, `daily`, `weekly`, `monthly`, `yearly` and `all_time`.\n\nFor example:\nThe `%fuji:highest_n_score zombie-kill-board 1 all_time%` returns `the highest zombie kill score` from the leaderboard with the id `zombie-kill-board`.\n")
    public static void registerHighestNScorePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("highest_n_score", 1753476193458L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            LeaderBoardArgumentsParseResult result = LeaderBoardPlaceholders.verifyRankNArguments(args);
            if (result.getErrorText() != null) {
                return result.getErrorText();
            }
            return LeaderBoardService.getHighestN(result.getLeaderBoardDescriptor(), result.getRankN(), result.getTimeWindow()).map(it -> class_2561.method_30163((String)String.valueOf(it.getEffectiveScore()))).orElseGet(LeaderBoardService::getNoScoreText);
        });
    }

    private static LeaderBoardArgumentsParseResult verifyRankNArguments(String args) {
        LeaderBoardTimeWindow timeWindow;
        int rankN;
        List<String> stringArgs = PlaceholderHelper.splitArguments(args);
        if (stringArgs.isEmpty()) {
            return new LeaderBoardArgumentsParseResult((class_2561)class_2561.method_43470((String)"[NO-LEADER-BOARD-ID-SPECIFIED]"), null, null, null);
        }
        if (stringArgs.size() == 1) {
            return new LeaderBoardArgumentsParseResult((class_2561)class_2561.method_43470((String)"[NO-RANK-N-SPECIFIED]"), null, null, null);
        }
        if (stringArgs.size() == 2) {
            return new LeaderBoardArgumentsParseResult((class_2561)class_2561.method_43470((String)"[NO-TIME-WINDOW-SPECIFIED]"), null, null, null);
        }
        String leaderBoardId = stringArgs.get(0);
        Optional<LeaderBoardDescriptor> leaderBoardDescriptor = LeaderBoardService.findLeaderBoardDescriptor(leaderBoardId);
        if (leaderBoardDescriptor.isEmpty()) {
            return new LeaderBoardArgumentsParseResult((class_2561)class_2561.method_43470((String)"[SPECIFIED-LEADERBOARD-NOT-FOUND]"), null, null, null);
        }
        LeaderBoardDescriptor $leaderBoardDescriptor = leaderBoardDescriptor.get();
        String rankNString = stringArgs.get(1);
        try {
            rankN = Integer.parseInt(rankNString);
        }
        catch (NumberFormatException e) {
            return new LeaderBoardArgumentsParseResult((class_2561)class_2561.method_43470((String)"[FAILED-TO-PARSE-RANK-N-INTO-INTEGER]"), null, null, null);
        }
        String timeWindowString = stringArgs.get(2);
        try {
            timeWindow = LeaderBoardTimeWindow.valueOf(StringUtil.toUpperCase(timeWindowString));
        }
        catch (IllegalArgumentException e) {
            return new LeaderBoardArgumentsParseResult((class_2561)class_2561.method_43470((String)"[INVALID-TIME-WINDOW]"), null, null, null);
        }
        return new LeaderBoardArgumentsParseResult(null, $leaderBoardDescriptor, rankN, timeWindow);
    }
}

