/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.maintenance.service;

import io.github.sakurawald.fuji.core.auxiliary.RandomUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.executor.CommandExecutor;
import io.github.sakurawald.fuji.core.command.executor.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerJoinedEvent;
import io.github.sakurawald.fuji.module.initializer.maintenance.MaintenanceModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.maintenance.config.model.MaintenanceConfigModel;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class MaintenanceService {
    public static boolean getMaintenanceModeStatus() {
        return MaintenanceModuleInitializer.config.model().isMaintenanceModeStatus();
    }

    public static boolean canJoinNow(@NotNull class_3222 player) {
        if (!MaintenanceService.getMaintenanceModeStatus()) {
            return true;
        }
        if (CommandHelper.Requirement.isOperator((class_1657)player)) {
            return true;
        }
        if (CommandHelper.Requirement.isAdmin(player.method_64396())) {
            return true;
        }
        return LuckpermsHelper.hasPermission(player.method_5667(), MaintenanceModuleInitializer.MAINTENANCE_BYPASS_PERMISSION, new Object[0]);
    }

    @EventConsumer
    public static void processMaintenanceModeOnPlayerJoined(PlayerJoinedEvent event) {
        class_3222 player = event.getPlayer();
        if (!MaintenanceService.canJoinNow(player)) {
            MaintenanceService.kickPlayer(player);
        }
    }

    public static void kickPlayer(@NotNull class_3222 player) {
        class_2561 reasonText = TextHelper.getTextByKey(player, "maintenance.disconnect", new Object[0]);
        PlayerHelper.disconnectPlayer(player, reasonText);
    }

    public static void setMaintenanceModeStatus(boolean status) {
        MaintenanceModuleInitializer.config.model().setMaintenanceModeStatus(status);
        MaintenanceModuleInitializer.config.writeStorage();
        MaintenanceService.processMaintenanceModeEvents();
    }

    private static void processMaintenanceModeEvents() {
        boolean currentStatus = MaintenanceService.getMaintenanceModeStatus();
        MaintenanceConfigModel.Events events = MaintenanceModuleInitializer.config.model().getEvents();
        List<String> commands = currentStatus ? events.getOnEnterMaintenanceModeCommands() : events.getOnLeaveMaintenanceModeCommands();
        ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(ServerHelper.getServer().method_3739());
        CommandExecutor.executeBatch(extendedCommandSource, commands);
    }

    public static class_2561 getEffectiveMaintenanceMessageText() {
        String message = RandomUtil.drawList(MaintenanceModuleInitializer.config.model().getMaintenanceMessages());
        return TextHelper.getTextByValue(null, message, new Object[0]);
    }
}

