/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.nametag.service;

import io.github.sakurawald.fuji.core.annotation.Unused;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerTeleportPreEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerWorldChangedEvent;
import io.github.sakurawald.fuji.core.event.message.server.tick.ServerTickEndEvent;
import io.github.sakurawald.fuji.module.initializer.nametag.NametagInitializer;
import io.github.sakurawald.fuji.module.initializer.nametag.structure.NametagEntity;
import io.github.sakurawald.fuji.module.initializer.nametag.structure.NametagEntitySyncer;
import io.github.sakurawald.fuji.module.initializer.nametag.structure.NametagPlayerPreferences;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class NametagService {
    public static Map<class_3222, NametagEntity> nametagEntityMap = new ConcurrentHashMap<class_3222, NametagEntity>();

    @NotNull
    private static NametagEntity setupNametagEntity(@NotNull class_3222 player) {
        NametagEntity nametagEntity = NametagEntity.make(player);
        NametagEntitySyncer.syncNametagEntityToClientWorld(nametagEntity);
        return nametagEntity;
    }

    public static void processNametagEntities() {
        nametagEntityMap.values().removeIf(NametagEntity::shouldRemove);
        PlayerHelper.Lookup.getOnlinePlayers().forEach(NametagService::processNametagEntity);
    }

    private static void processNametagEntity(@NotNull class_3222 player) {
        if (NametagService.getNametagEntityRemovedReason(player).isPresent()) {
            return;
        }
        NametagEntity nametagEntity = nametagEntityMap.computeIfAbsent(player, key -> NametagService.setupNametagEntity(player));
        nametagEntity.updateTrackedData();
    }

    @EventConsumer
    private static void tickNametagEntities(@Unused ServerTickEndEvent event) {
        nametagEntityMap.values().forEach(NametagEntity::method_5773);
    }

    private static void removeNametagEntity(class_3222 player) {
        Optional.ofNullable(nametagEntityMap.get(player)).ifPresent(NametagEntity::setRemoved);
    }

    @EventConsumer(injectorPriority=2000)
    private static void consumePlayerTeleportPreEvent(PlayerTeleportPreEvent event) {
        if (event.getCallbackInfo().isCancelled()) {
            return;
        }
        NametagService.removeNametagEntity(event.getPlayer());
    }

    @EventConsumer
    private static void consumePlayerWorldChangedEvent(PlayerWorldChangedEvent event) {
        NametagService.removeNametagEntity(event.getPlayer());
    }

    public static void removeAllNametagEntities() {
        nametagEntityMap.values().forEach(NametagEntity::setRemoved);
    }

    @NotNull
    public static NametagPlayerPreferences getOrCreateNametagPlayerPreferences(@NotNull class_3222 player) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        return NametagInitializer.data.model().getPreferences().computeIfAbsent(playerName, key -> new NametagPlayerPreferences());
    }

    public static Optional<String> getNametagEntityRemovedReason(@NotNull class_3222 ownerPlayer) {
        if (ownerPlayer.method_29504()) {
            return Optional.of("The entity is dead.");
        }
        if (ownerPlayer.method_5715()) {
            return Optional.of("The entity is sneaking.");
        }
        if (ownerPlayer.method_35049() != null) {
            return Optional.of("The entity is removed.");
        }
        if (ownerPlayer.method_5767()) {
            return Optional.of("The entity is invisible.");
        }
        if (!NametagService.getOrCreateNametagPlayerPreferences(ownerPlayer).isEnableNametagEntity()) {
            return Optional.of("The player has turn off the nametag entity.");
        }
        return Optional.empty();
    }
}

