/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.nametag.structure;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PacketHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.module.initializer.nametag.NametagInitializer;
import io.github.sakurawald.fuji.module.initializer.nametag.config.model.NametagConfigModel;
import io.github.sakurawald.fuji.module.initializer.nametag.service.NametagService;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2716;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class NametagEntity
extends class_8113.class_8123 {
    private final class_3222 ownerPlayer;

    private NametagEntity(@NotNull class_1299<?> entityType, @NotNull class_1937 world, @NotNull class_3222 ownerPlayer) {
        super(entityType, world);
        this.ownerPlayer = ownerPlayer;
    }

    @NotNull
    public static NametagEntity make(@NotNull class_3222 player) {
        LogUtil.debug("Make nametag for player: {}", PlayerHelper.getPlayerName((class_1657)player));
        NametagEntity nametagEntity = new NametagEntity(class_1299.field_42457, (class_1937)EntityHelper.getServerWorld((class_1297)player), player);
        nametagEntity.method_5684(true);
        return nametagEntity;
    }

    public boolean shouldRemove() {
        if (this.ownerPlayer.method_31481()) {
            return true;
        }
        return this.method_31481();
    }

    public void setRemoved() {
        PacketHelper.sendPacketToAll(new class_2716(new int[]{this.method_5628()}));
        this.method_5650(class_1297.class_5529.field_26999);
    }

    private void setDisplayFlag(byte flag, boolean value) {
        class_2945 dataTracker = this.method_5841();
        byte oldValue = (Byte)dataTracker.method_12789(class_8113.class_8123.field_42439);
        byte newValue = EntityHelper.withFlagValue(oldValue, flag, value);
        dataTracker.method_12778(class_8113.class_8123.field_42439, (Object)newValue);
    }

    public void updateTrackedData() {
        NametagConfigModel config = NametagInitializer.config.model();
        this.method_48847(class_8113.class_8114.field_42409);
        class_2561 text = TextHelper.getTextByValue(this.ownerPlayer, config.style.text, new Object[0]);
        this.method_48911(text);
        this.method_5841().method_12778(field_42401, (Object)new Vector3f(config.style.offset.x, config.style.offset.y, config.style.offset.z));
        this.method_48873(config.style.size.width);
        this.method_48875(config.style.size.height);
        this.method_48910(config.style.color.background);
        this.method_48909(config.style.color.text_opacity);
        if (config.style.brightness.override_brightness) {
            this.method_48846(new class_8104(config.style.brightness.block, config.style.brightness.sky));
        }
        this.method_5841().method_12778(field_42402, (Object)new Vector3f(config.style.scale.x, config.style.scale.y, config.style.scale.z));
        this.setDisplayFlag((byte)1, config.style.shadow.shadow);
        this.method_48862(config.style.shadow.shadow_radius);
        this.method_48872(config.style.shadow.shadow_strength);
        this.setDisplayFlag((byte)2, config.render.see_through_blocks);
        this.method_48861(config.render.view_range);
        List dirtyEntries = this.method_5841().method_12781();
        if (dirtyEntries != null) {
            class_2739 entityTrackerUpdateS2CPacket = new class_2739(this.method_5628(), dirtyEntries);
            PacketHelper.sendPacketToAll(entityTrackerUpdateS2CPacket);
        }
    }

    public void method_5773() {
        NametagService.getNametagEntityRemovedReason(this.ownerPlayer).ifPresent(reason -> {
            LogUtil.debug("Discard nametag entity {}: {}", new Object[]{this, reason});
            this.setRemoved();
        });
    }

    @Generated
    public class_3222 getOwnerPlayer() {
        return this.ownerPlayer;
    }
}

