/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.nametag.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PacketHelper;
import io.github.sakurawald.fuji.module.initializer.nametag.service.NametagService;
import io.github.sakurawald.fuji.module.initializer.nametag.structure.NametagEntity;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2739;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class NametagEntitySyncer {
    public static void syncNametagEntityToClientWorld(@NotNull NametagEntity nametagEntity) {
        NametagEntitySyncer.syncExistingNametagEntities(nametagEntity.getOwnerPlayer());
        NametagEntitySyncer.broadcastNewlyNametagEntityToAllPlayers(nametagEntity);
    }

    @NotNull
    private static class_2752 makeEntityPassengerSetPacket(@NotNull NametagEntity nametagEntity) {
        class_3222 ownerPlayer = nametagEntity.getOwnerPlayer();
        int entityId = ownerPlayer.method_5628();
        List list = ownerPlayer.method_5685();
        int[] passengerIds = new int[list.size() + 1];
        for (int i = 0; i < list.size(); ++i) {
            passengerIds[i] = ((class_1297)list.get(i)).method_5628();
        }
        passengerIds[passengerIds.length - 1] = nametagEntity.method_5628();
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10804(entityId);
        packetByteBuf.method_10806(passengerIds);
        return new class_2752(packetByteBuf);
    }

    private static void syncExistingNametagEntities(@NotNull class_3222 audience) {
        NametagService.nametagEntityMap.forEach((key, value) -> {
            class_2604 entitySpawnS2CPacket = NametagEntitySyncer.makeNametagEntitySpawnPacket(value);
            audience.field_13987.method_14364((class_2596)entitySpawnS2CPacket);
            class_2752 entityPassengersSetS2CPacket = NametagEntitySyncer.makeEntityPassengerSetPacket(value);
            audience.field_13987.method_14364((class_2596)entityPassengersSetS2CPacket);
            class_2739 entityTrackerUpdateS2CPacket = new class_2739(value.method_5628(), value.method_5841().method_46357());
            audience.field_13987.method_14364((class_2596)entityTrackerUpdateS2CPacket);
        });
    }

    @NotNull
    private static class_2604 makeNametagEntitySpawnPacket(@NotNull NametagEntity nametagEntity) {
        class_2338 blockPos = nametagEntity.getOwnerPlayer().method_24515().method_10069(0, 3, 0);
        return new class_2604((class_1297)nametagEntity, 0, blockPos);
    }

    private static void broadcastNewlyNametagEntityToAllPlayers(@NotNull NametagEntity nametagEntity) {
        class_2604 entitySpawnS2CPacket = NametagEntitySyncer.makeNametagEntitySpawnPacket(nametagEntity);
        PacketHelper.sendPacketToAll(entitySpawnS2CPacket);
        class_2752 entityPassengersSetS2CPacket = NametagEntitySyncer.makeEntityPassengerSetPacket(nametagEntity);
        PacketHelper.sendPacketToAll(entityPassengersSetS2CPacket);
    }
}

