/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.placeholder;

import com.google.common.collect.ImmutableList;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.RandomUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.MetaDescriptor;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerLeftEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.placeholder.gui.PlaceholderGui;
import io.github.sakurawald.fuji.module.initializer.placeholder.structure.SumUpPlaceholder;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

@Document(id=1751826512394L, value="Provides extra placeholders for `Text Placeholder API` mod.\n")
@ColorBoxes(value={@ColorBox(id=1751978623242L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Use `placeholder` in `language file`\nActually, you can write the `placeholder` in the `language file`.\nThe `contextual player` will be used to parse the placeholders.\n"), @ColorBox(id=1751978671933L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Install more mods to provide extra placeholders.\nSee https://placeholders.pb4.eu/user/mod-placeholders/\n")})
@CommandNode(value="placeholder")
@CommandRequirement(level=4)
public class PlaceholderInitializer
extends ModuleInitializer {
    private static final Map<String, Map<String, String>> ROTATE_CACHE = new HashMap<String, Map<String, String>>();
    private static final Pattern ESCAPE_PARSER = Pattern.compile("\\s*([\\s\\S]+)\\s+(\\d+)\\s*");

    @Document(id=1751826515140L, value="List all placeholders registered in server.")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_3222 player) {
        ImmutableList list = Placeholders.getPlaceholders().keySet().asList();
        new PlaceholderGui(player, (List<class_2960>)list, 0).open();
        return 1;
    }

    @Document(id=1751826519376L, value="Parse a placeholder with a contextual player.")
    @CommandNode(value="parse")
    private static int $parse(@CommandSource class_2168 source, Optional<class_3222> player, GreedyString input) {
        class_3222 target = player.orElse(null);
        class_2561 text = TextHelper.getTextByValue(target, (String)input.getValue(), new Object[0]);
        TextHelper.sendMessageByText(source, text);
        return 1;
    }

    @DocStringProvider(id=1751999849427L, value="Returns the total playtime of all players in the server.\n")
    private static void registerServerPlaytimePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("server_playtime", 1751999849427L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().playtime)));
    }

    @DocStringProvider(id=1751999873162L, value="Returns the playtime of the player.\n")
    private static void registerPlayerPlaytimePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_playtime", 1751999873162L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).playtime)));
    }

    @DocStringProvider(id=1751999885958L, value="Returns the total distance traveled by all players in the server.\n")
    private static void registerServerMovedPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("server_moved", 1751999885958L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().moved)));
    }

    @DocStringProvider(id=1751999903574L, value="Returns the distance traveled by the player.\n")
    private static void registerPlayerMovedPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_moved", 1751999903574L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).moved)));
    }

    @DocStringProvider(id=1751999917216L, value="Returns the total entities killed by all players in the server.\n")
    private static void registerServerKilledPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("server_killed", 1751999917216L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().killed)));
    }

    @DocStringProvider(id=1751999930297L, value="Returns the killed entities by the player.\n")
    private static void registerPlayerKilledPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_killed", 1751999930297L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).killed)));
    }

    @DocStringProvider(id=1751999941071L, value="Returns the total placed blocks by all players in the server.\n")
    private static void registerServerPlacedPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("server_placed", 1751999941071L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().placed)));
    }

    @DocStringProvider(id=1751999952462L, value="Returns the placed blocks by the player.\n")
    private static void registerPlayerPlacedPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_placed", 1751999952462L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).placed)));
    }

    @DocStringProvider(id=1751999963243L, value="Returns the total mined blocks by all players in the server.\n")
    private static void registerServerMinedPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("server_mined", 1751999963243L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, server -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofServer().mined)));
    }

    @DocStringProvider(id=1751999973284L, value="Returns the mined blocks by the player.\n")
    private static void registerPlayerMinedPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_mined", 1751999973284L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> class_2561.method_43470((String)String.valueOf(SumUpPlaceholder.ofPlayer((String)player.method_5845()).mined)));
    }

    @DocStringProvider(id=1751999986462L, value="Returns the `luckperms prefix` of the player.\n")
    public static void registerPrefixPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_prefix", 1751999986462L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, (player, arg) -> {
            String prefix = LuckpermsHelper.getPrefix(player.method_5667());
            return TextHelper.getTextByValue(player, prefix, new Object[0]);
        });
    }

    @DocStringProvider(id=1751999997365L, value="Returns the `luckperms suffix` of the player.\n")
    public static void registerSuffixPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("player_suffix", 1751999997365L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, (player, arg) -> {
            String prefix = LuckpermsHelper.getSuffix(player.method_5667());
            return TextHelper.getTextByValue(player, prefix, new Object[0]);
        });
    }

    @DocStringProvider(id=1752000048133L, value="Returns the `location` of the player.\n")
    public static void registerPosPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("pos", 1752000048133L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> {
            int blockX = player.method_31477();
            int blockY = player.method_31478();
            int blockZ = player.method_31479();
            class_3218 world = PlayerHelper.getServerWorld(player);
            String dimensionName = RegistryHelper.getIdAsString((class_1937)world);
            String dimensionDisplayName = TextHelper.Translator.getLanguageValueByKey(player, dimensionName);
            String biomeName = WorldHelper.getBiomeId(world, player.method_24515());
            class_2561 positionText = TextHelper.getTextByKey(player, "placeholder.position", dimensionDisplayName, blockX, blockY, blockZ, biomeName);
            String currentPosition = "(%d, %d, %d)".formatted(blockX, blockY, blockZ);
            class_5250 hoverText = class_2561.method_43473();
            hoverText.method_10852(TextHelper.getTextByKey(player, "placeholder.current_position", currentPosition));
            String linkedDimensionDisplayName = null;
            String linkedDimensionPosition = null;
            switch (dimensionName) {
                case "minecraft:overworld": {
                    linkedDimensionDisplayName = TextHelper.Translator.getLanguageValueByKey(player, "minecraft:the_nether");
                    linkedDimensionPosition = "(%d, %d, %d)".formatted(blockX / 8, blockY, blockZ / 8);
                    break;
                }
                case "minecraft:the_nether": {
                    linkedDimensionDisplayName = TextHelper.Translator.getLanguageValueByKey(player, "minecraft:overworld");
                    linkedDimensionPosition = "(%d, %d, %d)".formatted(blockX * 8, blockY, blockZ * 8);
                }
            }
            if (linkedDimensionPosition != null) {
                hoverText.method_10852(TextHelper.TEXT_NEWLINE);
                hoverText.method_10852(TextHelper.getTextByKey(player, "placeholder.coordinate_scale", linkedDimensionDisplayName, linkedDimensionPosition));
            }
            String waypointName = TextHelper.Translator.getLanguageValueByKey(player, "placeholder.position.waypoint.name");
            String waypointSingularCharacterName = String.valueOf(waypointName.charAt(0));
            String nameOfDimension = RegistryHelper.makeIdentifierOrThrow(RegistryHelper.getIdAsString((class_1937)world)).method_12832();
            String xaeroCommand = "xaero-waypoint:%s:%s:%d:%d:%d:11:false:0:Internal-%s-waypoints".formatted(waypointName, waypointSingularCharacterName, blockX, blockY, blockZ, nameOfDimension);
            hoverText.method_10852(TextHelper.TEXT_NEWLINE);
            hoverText.method_10852(TextHelper.getTextByKey(player, "placeholder.prompt.xaero_waypoint_add", new Object[0]));
            return positionText.method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction((class_2561)hoverText)).method_10958(TextHelper.Events.ClickEvent.makeSuggestCommandAction(xaeroCommand)));
        });
    }

    @EventConsumer
    private static void removeSumUpPlaceholderOnPlayerLeft(PlayerLeftEvent event) {
        SumUpPlaceholder.uuid2stats.remove(event.getPlayer().method_5845());
    }

    @Override
    protected void onInitialize() {
        PlaceholderInitializer.registerPlayerMinedPlaceholder();
        PlaceholderInitializer.registerServerMinedPlaceholder();
        PlaceholderInitializer.registerPlayerPlacedPlaceholder();
        PlaceholderInitializer.registerServerPlacedPlaceholder();
        PlaceholderInitializer.registerPlayerKilledPlaceholder();
        PlaceholderInitializer.registerServerKilledPlaceholder();
        PlaceholderInitializer.registerPlayerMovedPlaceholder();
        PlaceholderInitializer.registerServerMovedPlaceholder();
        PlaceholderInitializer.registerPlayerPlaytimePlaceholder();
        PlaceholderInitializer.registerServerPlaytimePlaceholder();
        this.registerHealthBarPlaceholder();
        this.registerRotatePlaceholder();
        this.registerHasPermissionPlaceholder();
        this.registerGetMetaPlaceholder();
        this.registerRandomPlayerPlaceholder();
        this.registerRandomPlaceholder();
        this.registerEscapePlaceholder();
        this.registerProtectPlaceholder();
        this.registerDatePlaceholder();
        PlaceholderInitializer.registerPrefixPlaceholder();
        PlaceholderInitializer.registerSuffixPlaceholder();
        PlaceholderInitializer.registerPosPlaceholder();
    }

    @DocStringProvider(id=1752000061565L, value="Returns current `date`.\nAccept an optional argument to specify the `date format`.\n\nFor example:\n- `%fuji:date yyyy MM dd%`\n\nSee details in https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html\n")
    private void registerDatePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("date", 1752000061565L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, arg) -> {
            if (arg == null || arg.isBlank()) {
                return class_2561.method_43470((String)ChronosUtil.Formatter.getFormattedCurrentDate());
            }
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(arg);
                String currentDate = ChronosUtil.Formatter.getFormattedCurrentDate(formatter);
                return class_2561.method_43470((String)currentDate);
            }
            catch (Exception e) {
                return class_2561.method_30163((String)("Invalid date formatter: " + arg));
            }
        });
    }

    @DocStringProvider(id=1752000074625L, value="To escape the `placeholder` from the `text parser`.\nThe `first argument` is the literal string of the `target placeholder`.\nThe `second argument` is the integer for `escape levels`, by default is 1.\n")
    private void registerEscapePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("escape", 1752000074625L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            if (args == null) {
                return PlaceholderHelper.makeInvalidArgsErrorText();
            }
            Matcher matcher = ESCAPE_PARSER.matcher((CharSequence)args);
            if (matcher.find()) {
                String placeholder = matcher.group(1);
                int level = Integer.parseInt(matcher.group(2));
                if (level == 1) {
                    return class_2561.method_43470((String)("%" + placeholder + "%"));
                }
                if (level > 1) {
                    return class_2561.method_43470((String)("%fuji:escape " + placeholder + " " + (level - 1) + "%"));
                }
            }
            return class_2561.method_43470((String)("%" + args + "%"));
        });
    }

    @DocStringProvider(id=1752000094346L, value="Accept one `required string argument`, and returns the `literal text` of that.\n")
    private void registerProtectPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("protect", 1752000094346L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            if (args == null) {
                return class_2561.method_43473();
            }
            return class_2561.method_43470((String)args);
        });
    }

    @DocStringProvider(id=1752000110013L, value="The `first string argument` is the `permission` to check.\nReturns whether the `player` has that permission, in boolean.\n")
    private void registerHasPermissionPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("has_permission", 1752000110013L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, (player, args) -> {
            boolean value = LuckpermsHelper.hasPermission(player.method_5667(), new PermissionDescriptor(true, (String)args, 0L), new Object[0]);
            return class_2561.method_43470((String)String.valueOf(value));
        });
    }

    @DocStringProvider(id=1752000128157L, value="The `first string argument` is the `luckperms meta` key.\nReturns the `string` to represent the `meta value`.\n")
    private void registerGetMetaPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("get_meta", 1752000128157L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, (player, args) -> {
            MetaDescriptor<String> tempMeta = new MetaDescriptor<String>(true, (String)args, String::valueOf, 0L);
            Optional<String> metaValue = LuckpermsHelper.getMeta(player.method_5667(), tempMeta, new Object[0]);
            return class_2561.method_43470((String)metaValue.orElse("META_NOT_FOUND_ERROR"));
        });
    }

    @DocStringProvider(id=1752000163280L, value="Pick a `random` player in `online` players, and returns its `name`.\n")
    private void registerRandomPlayerPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("random_player", 1752000163280L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            List<class_3222> playerList = PlayerHelper.Lookup.getOnlinePlayers();
            class_3222 serverPlayerEntity = RandomUtil.drawList(playerList);
            return class_2561.method_43470((String)serverPlayerEntity.method_7334().getName());
        });
    }

    @DocStringProvider(id=1752000183895L, value="The `first integer argument` is the `min value`.\nThe `second integer argument` is the `max value`,\nReturns a random integer ranged `[min, max)`.\n")
    private void registerRandomPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("random", 1752000183895L);
        PlaceholderHelper.registerServerPlaceholder(descriptor, (server, args) -> {
            int i;
            if (args == null) {
                return PlaceholderHelper.makeInvalidArgsErrorText();
            }
            List<String> split = PlaceholderHelper.splitArguments(args);
            if (split.size() != 2) {
                return PlaceholderHelper.makeInvalidArgsErrorText();
            }
            try {
                int minInclusive = Integer.parseInt(split.get(0));
                int maxExclusive = Integer.parseInt(split.get(1));
                i = RandomUtil.getRandomNumberExclusive(minInclusive, maxExclusive);
            }
            catch (Exception e) {
                return PlaceholderHelper.makeInvalidArgsErrorText();
            }
            return class_2561.method_43470((String)String.valueOf(i));
        });
    }

    @DocStringProvider(id=1752000211964L, value="Returns the `health` of the `player`, in visual heart characters.\n")
    private void registerHealthBarPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("health_bar", 1752000211964L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> {
            int totalHearts = 10;
            int filledHearts = (int)(player.method_6032() / 2.0f);
            int unfilledHearts = totalHearts - filledHearts;
            String str = "\u2665".repeat(filledHearts) + "\u2661".repeat(unfilledHearts);
            return class_2561.method_43470((String)str);
        });
    }

    private void registerRotatePlaceholder() {
        Placeholders.register((class_2960)class_2960.method_60655((String)"fuji", (String)"rotate"), (ctx, args) -> {
            String namespace = "default";
            if (ctx.player() != null) {
                namespace = ctx.player().method_7334().getName();
            }
            ROTATE_CACHE.putIfAbsent(namespace, new HashMap());
            Map<String, String> rotateMap = ROTATE_CACHE.get(namespace);
            rotateMap.putIfAbsent(args, args);
            String frame = rotateMap.get(args);
            rotateMap.put(args, StringUtils.rotate((String)frame, (int)-1));
            return PlaceholderResult.value((class_2561)class_2561.method_43470((String)frame));
        });
    }
}

