/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.pvp;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerDamageEvent;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.pvp.config.model.PvPDataModel;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751826840711L, value="Provides PvP management for players.\n")
public class PvpInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<PvPDataModel> data = ObjectConfigurationHandler.ofModule("pvp.json", PvPDataModel.class);

    @Document(id=1751826842506L, value="Enable the PvP for the player.")
    @CommandNode(value="pvp on")
    private static int $on(@CommandSource @CommandTarget class_3222 player) {
        Set<String> whitelist = PvpInitializer.data.model().whitelist;
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        if (!whitelist.contains(playerName)) {
            whitelist.add(playerName);
            data.writeStorage();
            TextHelper.sendTextByKey(player, "pvp.on", new Object[0]);
            return 1;
        }
        TextHelper.sendTextByKey(player, "pvp.on.already", new Object[0]);
        return 0;
    }

    @Document(id=1751826844847L, value="Disable the PvP for the player.")
    @CommandNode(value="pvp off")
    private static int $off(@CommandSource @CommandTarget class_3222 player) {
        Set<String> whitelist = PvpInitializer.data.model().whitelist;
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        if (whitelist.contains(playerName)) {
            whitelist.remove(playerName);
            data.writeStorage();
            TextHelper.sendTextByKey(player, "pvp.off", new Object[0]);
            return 1;
        }
        TextHelper.sendTextByKey(player, "pvp.off.already", new Object[0]);
        return 0;
    }

    @Document(id=1751826847105L, value="Query the status of PvP for the player.")
    @CommandNode(value="pvp status")
    private static int $status(@CommandSource @CommandTarget class_3222 player) {
        Set<String> whitelist = PvpInitializer.data.model().whitelist;
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        boolean flag = whitelist.contains(playerName);
        TextHelper.sendMessageByText(player, TextHelper.getTextByKey(player, flag ? "pvp.status.on" : "pvp.status.off", new Object[0]));
        return 1;
    }

    @Document(id=1751826854234L, value="List the players that enable the PvP.")
    @CommandNode(value="pvp list")
    private static int $list(@CommandSource class_2168 source) {
        Set<String> whitelist = PvpInitializer.data.model().whitelist;
        TextHelper.sendTextByKey(source, "pvp.list", whitelist);
        return 1;
    }

    public static boolean isPvpEnabled(String name) {
        return PvpInitializer.data.model().whitelist.contains(name);
    }

    @EventConsumer
    private static void processPvpDamage(PlayerDamageEvent event) {
        class_1297 damageSourceEntity = event.getDamageSource().method_5526();
        if (damageSourceEntity instanceof class_3222) {
            class_3222 damageSourcePlayer = (class_3222)damageSourceEntity;
            if (damageSourceEntity.equals((Object)event.getPlayer())) {
                return;
            }
            String damageSourcePlayerName = PlayerHelper.getPlayerName((class_1657)damageSourcePlayer);
            if (!PvpInitializer.isPvpEnabled(damageSourcePlayerName)) {
                TextHelper.sendTextByKey(damageSourcePlayer, "pvp.check.off.me", new Object[0]);
                event.setDamage(0.0f);
                return;
            }
            String damageTargetPlayerName = PlayerHelper.getPlayerName((class_1657)event.getPlayer());
            if (!PvpInitializer.isPvpEnabled(damageTargetPlayerName)) {
                TextHelper.sendTextByKey(damageSourcePlayer, "pvp.check.off.others", damageTargetPlayerName);
                event.setDamage(0.0f);
            }
        }
    }
}

