/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.rank;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import io.github.sakurawald.fuji.module.initializer.rank.service.RankService;
import io.github.sakurawald.fuji.module.initializer.rank.structure.RankNode;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class RankPlaceholders {
    @DocStringProvider(id=1754432388361L, value="Returns the `rank id` of the player's current rank.\n")
    public static void registerRankIdPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("rank_id", 1754432388361L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> RankPlaceholders.mapIntoText(player, it -> class_2561.method_30163((String)it.getId())));
    }

    @DocStringProvider(id=1754432587319L, value="Returns the `rank display name` of the player's current rank.\n")
    public static void registerRankDisplayNamePlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("rank_displayname", 1754432587319L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> RankPlaceholders.mapIntoText(player, it -> TextHelper.getTextByValue(null, it.getDisplayName(), new Object[0])));
    }

    @DocStringProvider(id=1754432726443L, value="Returns the `rank display name raw string` of the player's current rank.\n")
    public static void registerRankDisplayNameRawPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("rank_displayname_raw", 1754432726443L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, player -> RankPlaceholders.mapIntoText(player, it -> class_2561.method_30163((String)it.getDisplayName())));
    }

    @NotNull
    private static class_2561 mapIntoText(@NotNull class_3222 player, @NotNull Function<RankNode, class_2561> mapper) {
        return RankService.getCurrentRankNode(player).map(mapper).orElseGet(RankService::getNoRankStatusText);
    }
}

