/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.rtp;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.argument.wrapper.abst.SingularValue;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.random_teleport.RandomTeleporter;
import io.github.sakurawald.fuji.core.service.random_teleport.structure.RandomTeleportSettings;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.rtp.config.model.RtpConfigModel;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826337744L, value="Provides random teleportation.\n")
@ColorBoxes(value={@ColorBox(id=1757810706176L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Features\n- Per-dimension settings\n- Real-time searching feedback.\n- Full async `chunk loading` and `chunk generation`. (Lag-free)\n- Customization of `center x` and `center z`\n- Customization of `min range` and `max range`\n- Supported `circle` and `rectangle` shape.\n- Respect `world border`.\n- Skip any `liquid block`.\n- Filter the result by `min Y` and `max Y`\n- Filter the result by `specified blocks`\n- Filter the result by `specified biomes`\n- Filter the result by `chunk inhabited time`\n"), @ColorBox(id=1751978954547L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Improve the performance of rtp.\nIt's highly recommended to pre generate the world chunks using `chunky` mod.\nIf the `target chunk` is not generated, then we have to generate it while doing the random teleport.\nTo generate a chunk requires about 2 seconds to 10 seconds.\nWhich will slow down the process of `/rtp`.\nIf you pre generates the world chunks, then it will be fast.\n"), @ColorBox(id=1751979061910L, color=ColorBox.ColorBoxTypes.TIPS, value="\u25c9 Limit the usage of `/rtp` command\nYou can use `command_cooldown` module, to setup a `cooldown` for `/rtp` command.\nTo prevent abuse.\n")})
public class RtpInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<RtpConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", RtpConfigModel.class);

    private static Optional<RandomTeleportSettings> getRandomTeleportSettings(@NotNull class_3218 world) {
        List<RandomTeleportSettings> list = config.model().getDimensions().getSettings();
        String dimension = RegistryHelper.getIdAsString((class_1937)world);
        return list.stream().filter(RandomTeleportSettings::isEnable).filter(o -> o.getDimension().equals(dimension)).findFirst();
    }

    @Document(id=1751826340406L, value="Random rtp in specified dimension.")
    @CommandNode(value="rtp")
    private static int $rtp(@CommandSource @CommandTarget class_3222 player, Optional<Dimension> dimension) {
        class_3218 serverWorld = dimension.map(SingularValue::getValue).orElseGet(() -> EntityHelper.getServerWorld((class_1297)player));
        RandomTeleportSettings settings = RtpInitializer.getRandomTeleportSettings(serverWorld).orElseThrow(() -> {
            TextHelper.sendTextByKey(player, "rtp.dimension.disallow", RegistryHelper.getIdAsString((class_1937)serverWorld));
            return new AbortCommandExecutionException();
        });
        RandomTeleporter.request(player, settings, null);
        return 1;
    }
}

