/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.system_message;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.system_message.config.model.SystemMessageConfigModel;
import io.github.sakurawald.fuji.module.initializer.system_message.config.transformer.SystemMessageV1SchemaTransformer;
import io.github.sakurawald.fuji.module.initializer.system_message.structure.SystemMessageRule;
import java.util.Optional;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751824913807L, value="Customize the `translatable text`, like most of `system messages`.\n\nFor example, you can customize the `translatable texts` like:\n1. Player joined and left message.\n2. Player death message. (Like get killed by a zombie)\n3. Player whitelist message. (Used in the GUI)\n4. Player advancement message.\n5. Player command feedback. (The command feedback for a specified command)\n6. Server close message.\n7. Player banned screen message.\n8. ... (There are many translatable texts in server-side)\n")
@ColorBoxes(value={@ColorBox(id=1751979387990L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 What is a `translatable text`.\nIn client-side, you can change the `language option`, and see different `translatable texts`.\nThere are `language files for different languages` in your client.\nThings are similar in server-side.\nThere are `language files for different languages` in the `server side`.\n\nYou can see the example `language file` in https://github.com/sakurawald/fuji/blob/dev/.github/files/en_us.json\n\n\u25c9 How this module works?\nWhen the `server` tries to sends a `translatable text` to the `client` side.\nWe will see what `translatable text` is going to be sent, and `replace` it with `user-defined text` if needed.\nThe client just receive the `user-define text`, and display it to the player.\n"), @ColorBox(id=1751979760808L, color=ColorBox.ColorBoxTypes.WARNING, value="\u25c9 Don't customize the `translatable text` that is already handled by other mods\nFor example, if you are using `Styled Chat` mod, then you should not modify the `player join message` and `player leave message`.\nBecause the `Styled Chat` mod already handles them.\n"), @ColorBox(id=1751979931584L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Customize the player join message\nKey: `multiplayer.player.joined`\nValue: `\\<rainbow\\>+ %s`\n\n\u25c9 Customize the player leave mssage\nKey: `multiplayer.player.left`\nValue: `\\<dark_gray\\>%s leeeeeeeeft the game`\n"), @ColorBox(id=1751979996501L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Customize a specific death type message\nKey: `death.attack.explosion.player`\nValue: `\\<rainbow\\>%1$s booooooom because of %2$s`\n\n\u25c9 Customize a specific vanilla command feedback message\nKey: `commands.seed.success`\nValue: `\\<rainbow\\> Seeeeeeeeeeed: %s`\n"), @ColorBox(id=1751980039595L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Customize the text used in screen.\nKey: `multiplayer.disconnect.server_shutdown`\nValue: `Server closeeeeeeeed`\n\nKey: `multiplayer.disconnect.not_whitelisted`\nValue: `\\<rainbow\\>Please apply a whitelist first!`\n\nKey: `container.chest`\nValue: `\\<rb\\>I see you opening the chest!`\n"), @ColorBox(id=1751980149228L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Cancel the sending of a specific message.\nKey: `multiplayer.player.left`\nValue: `null`\n\n<green>NOTE: If you leave the `value` to `null`, then it means let's `cancel` the sending of this translatable text.\n"), @ColorBox(id=1753460512853L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Customize the `text` in a `screen`.\nYes, you can customize the `text` in a `screen`, like the `ban screen`.\nKey: `multiplayer.disconnect.banned`\nValue: `\\<red\\>You are banned from this server`\n\nKey: `multiplayer.disconnect.banned.reason`\nValue: `\\<red\\>You are banned from this server\\<newline\\>\\<yellow\\>Reason: %s`\n")})
@TestCase(action="Test the functionality of this module.", targets={"The player joined text should be modified, with custom color.", "The player left text sending should be cancelled", "The chest title text should be modified", "Issue `/gamerule showDeathMessages` command, you should see the command feedback.", "Issue `/seed` command, you should see the modified command feedback.", "Issue `/ban` command, you should see the modified ban screen.", "Fell from a high place, you should see the modified death message."})
public class SystemMessageInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<SystemMessageConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", SystemMessageConfigModel.class).installTransformer(new SystemMessageV1SchemaTransformer());

    public static Optional<class_5250> computeTranslatableTextResult(@NotNull SystemMessageRule rule, @Nullable class_3222 receiverPlayer, @NotNull String translatableKey, Object ... args) {
        LogUtil.debug("Process system message: translatable key = {}, player = {}", translatableKey, receiverPlayer);
        if (ServerHelper.getServer() == null) {
            LogUtil.warn("Server is null currently, cannot modify the translatable text with the key: {} (NOTE: Please delete this translatable key in your config file)", translatableKey);
            return Optional.empty();
        }
        @Nullable String value = rule.getTranslatableTextValue();
        if (value == null) {
            LogUtil.debug("Cancel sending message {} to audience {}.", translatableKey, receiverPlayer);
            return Optional.empty();
        }
        class_2588 forceFallbackToSpecifiedValue = new class_2588("fuji_system_message_module$force_fallback", value, args);
        String resolveArgumentsAsString = class_5250.method_43477((class_7417)forceFallbackToSpecifiedValue).getString();
        class_5250 newText = TextHelper.getTextByValue(receiverPlayer, resolveArgumentsAsString, new Object[0]).method_27661();
        LogUtil.debug("Replace the translatable text {} with new value {}.", translatableKey, newText);
        return Optional.of(newText);
    }

    @NotNull
    public static Optional<SystemMessageRule> findApplicableRule(@NotNull String translatableKey) {
        return config.model().getRules().stream().filter(SystemMessageRule::isEnable).filter(rule -> rule.getTranslatableTextKey().equals(translatableKey)).findFirst();
    }
}

