/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.temp_ban;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GameProfileCollection;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.service.duration_parser.DurationParser;
import io.github.sakurawald.fuji.core.service.duration_parser.command.argument.wrapper.Duration;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3320;
import net.minecraft.class_3324;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.server.MinecraftServer;

@Document(id=1751980813637L, value="This module provides the `/temp-ban` command.\nSo that you can specify `the duration` for `/ban` command.\n")
@ColorBox(id=1751980845082L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 All in one example\nIssue: `/temp-ban player Alice 1s2m3h4d5w6M7y bad boy`\n")
@CommandNode(value="temp-ban")
@CommandRequirement(level=4)
public class TempBanInitializer
extends ModuleInitializer {
    @CommandNode(value="ip")
    private static int $ip(@CommandSource class_2168 source, String ip, Duration expiry, GreedyString reason) throws CommandSyntaxException {
        if (!InetAddresses.isInetAddress((String)ip)) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.banip.invalid")).create();
        }
        Date expire = DurationParser.parseIntoExpirationDate((String)expiry.getValue()).orElseThrow();
        class_3320 bannedIpEntry = new class_3320(ip, null, source.method_9214(), expire, (String)reason.getValue());
        source.method_9211().method_3760().method_14585().method_14633((class_3330)bannedIpEntry);
        source.method_9226(() -> class_2561.method_43469((String)"commands.banip.success", (Object[])new Object[]{ip, bannedIpEntry.method_14503()}), true);
        List list = source.method_9211().method_3760().method_14559(ip);
        if (!list.isEmpty()) {
            source.method_9226(() -> class_2561.method_43469((String)"commands.banip.info", (Object[])new Object[]{list.size(), class_2300.method_9822((List)list)}), true);
        }
        for (class_3222 serverPlayerEntity : list) {
            serverPlayerEntity.field_13987.method_52396((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.ip_banned"));
        }
        return 1;
    }

    @CommandNode(value="player")
    private static int $player(@CommandSource class_2168 source, GameProfileCollection collection, Duration expiry, GreedyString reason) {
        MinecraftServer server = source.method_9211();
        class_3324 playerManager = server.method_3760();
        Date expire = DurationParser.parseIntoExpirationDate((String)expiry.getValue()).orElseThrow();
        for (GameProfile gameProfile : (Collection)collection.getValue()) {
            class_3336 bannedPlayerEntry = new class_3336(gameProfile, null, source.method_9214(), expire, (String)reason.getValue());
            playerManager.method_14563().method_14633((class_3330)bannedPlayerEntry);
            source.method_9226(() -> class_2561.method_43469((String)"commands.ban.success", (Object[])new Object[]{class_2561.method_43470((String)gameProfile.getName()), bannedPlayerEntry.method_14503()}), true);
            class_3222 serverPlayerEntity = playerManager.method_14602(gameProfile.getId());
            if (serverPlayerEntity == null) continue;
            serverPlayerEntity.field_13987.method_52396((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.banned"));
        }
        return 1;
    }
}

