/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.view;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.view.gui.EnderChestRedirectScreenFactory;
import io.github.sakurawald.fuji.module.initializer.view.gui.InventoryRedirectScreenFactory;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

@Document(id=1751824970923L, value="Allow you to edit a player's `slots`.\n\n1. Edit an online/offline player's `inventory`.\n2. Edit an online/offline player's `enderchest`.\n")
@CommandNode(value="view")
@CommandRequirement(level=4)
@TestCase(action="Issue the `/view {inv/ender}` command on a fake-player.", targets={"You should be able to modify the slots on the fly."})
public class ViewInitializer
extends ModuleInitializer {
    private static void checkSelfView(class_3222 source, OfflinePlayerName target) {
        if (source.method_7334().getName().equals(target.getValue())) {
            TextHelper.sendTextByKey(source, "view.failed.self_view", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @Document(id=1751824976609L, value="View the player's inventory.")
    @CommandNode(value="inv")
    private static int $inv(@CommandSource class_3222 source, OfflinePlayerName target) {
        ViewInitializer.checkSelfView(source, target);
        source.method_17355((class_3908)new InventoryRedirectScreenFactory(source, (String)target.getValue()).makeFactory());
        return 1;
    }

    @Document(id=1751824982580L, value="View the player's enderchest.")
    @CommandNode(value="ender")
    private static int $ender(@CommandSource class_3222 source, OfflinePlayerName target) {
        ViewInitializer.checkSelfView(source, target);
        source.method_17355((class_3908)new EnderChestRedirectScreenFactory(source, (String)target.getValue()).makeFactory());
        return 1;
    }
}

