/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.warning;

import io.github.sakurawald.fuji.core.auxiliary.ChronosUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.annotation.CommandNode;
import io.github.sakurawald.fuji.core.command.annotation.CommandRequirement;
import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ColorBox;
import io.github.sakurawald.fuji.core.document.annotation.ColorBoxes;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.event.annotation.EventConsumer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerJoinedEvent;
import io.github.sakurawald.fuji.core.event.message.player.PlayerLeftEvent;
import io.github.sakurawald.fuji.core.service.duration_parser.DurationParser;
import io.github.sakurawald.fuji.core.service.duration_parser.command.argument.wrapper.Duration;
import io.github.sakurawald.fuji.module.initializer.ModuleInitializer;
import io.github.sakurawald.fuji.module.initializer.warning.WarningPlaceholders;
import io.github.sakurawald.fuji.module.initializer.warning.config.model.WarningConfigModel;
import io.github.sakurawald.fuji.module.initializer.warning.config.model.WarningDataModel;
import io.github.sakurawald.fuji.module.initializer.warning.gui.WarningGui;
import io.github.sakurawald.fuji.module.initializer.warning.service.WarningService;
import io.github.sakurawald.fuji.module.initializer.warning.structure.PlayerWarnings;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

@Document(id=1751827033037L, value="This module provides the `information management` for `staffs`.\nA shared `warning GUI` to `track` the behaviours of players, between `staffs`.\nYou can `create` a `warning` for a `player`.\nAll `staffs` can `view` the `warnings` of a `player`.\n\nYou can use `warnings` to `track` the behaviours of a `player`.\n")
@ColorBoxes(value={@ColorBox(id=1754646463245L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Integrate with advanced `ban` tools.\nYou can integrate the `warning` module with `temp_ban` module.\nHowever, you may want some advanced ban tools.\nSee: https://github.com/Patbox/BanHammer\n"), @ColorBox(id=1754643107428L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a `permanent warning` for a player.\nIssue: `/warning create Steve Steal items.`\n\n\u25c9 Create a `temporal warning` for a player.\nIssue: `/warning create-temp Steve 3d Steal items.`\n\n\u25c9 List all the warnings of a player.\nIssue: `/warning list Steve`\n\n\u25c9 Open the `Warning GUI`.\nIssue: `/warning gui`\n")})
public class WarningInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000385223L, value="To `create` a new `warning` for a `player`.")
    public static PermissionDescriptor CREATE_WARNINGS_PERMISSION = new PermissionDescriptor("fuji.warning.create", 1752000385223L);
    @DocStringProvider(id=1752000399374L, value="To `read` the `warnings` of a `player`.")
    public static PermissionDescriptor READ_WARNINGS_PERMISSION = new PermissionDescriptor("fuji.warning.read", 1752000399374L);
    @DocStringProvider(id=1752000453811L, value="To `update` the `warnings` of a `player`.")
    public static PermissionDescriptor UPDATE_WARNINGS_PERMISSION = new PermissionDescriptor("fuji.warning.update", 1752000453811L);
    @DocStringProvider(id=1752000473509L, value="To `delete` an existed `warning` of a `player`.")
    public static PermissionDescriptor DELETE_WARNINGS_PERMISSION = new PermissionDescriptor("fuji.warning.delete", 1752000473509L);
    @DocStringProvider(id=1752000488085L, value="When a `player` with `warnings` join/leave the server, you will get notified.")
    public static PermissionDescriptor NOTIFY_WARNINGS_PERMISSION = new PermissionDescriptor("fuji.warning.notify", 1752000488085L);
    public static final BaseConfigurationHandler<WarningConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", WarningConfigModel.class);
    public static final BaseConfigurationHandler<WarningDataModel> data = ObjectConfigurationHandler.ofModule("warning-data.json", WarningDataModel.class);

    @Document(id=1751827034962L, value="Open the warning GUI.")
    @CommandNode(value="warning")
    @CommandRequirement(level=4)
    private static int $warningRoot(@CommandSource class_3222 player) {
        WarningInitializer.$warningGui(player);
        return 1;
    }

    @Document(id=1751827036716L, value="Open the warning GUI.")
    @CommandNode(value="warning gui")
    @CommandRequirement(level=4)
    private static int $warningGui(@CommandSource class_3222 player) {
        List<String> offlinePlayerNames = PlayerHelper.Cache.getOfflinePlayerNames();
        new WarningGui(null, player, offlinePlayerNames, 0).open();
        return 1;
    }

    @Document(id=1751827038512L, value="Create a new warning for the player.")
    @CommandNode(value="warning create")
    @CommandRequirement(level=4)
    private static int $createWarning(@CommandSource class_2168 source, OfflinePlayerName targetPlayer, GreedyString warning) {
        return WarningInitializer.$createTemporalWarning(source, targetPlayer, new Duration(null), warning);
    }

    @Document(id=1754620576300L, value="Create a new warning with expiration for the player.")
    @CommandNode(value="warning create-temp")
    @CommandRequirement(level=4)
    private static int $createTemporalWarning(@CommandSource class_2168 source, OfflinePlayerName targetPlayer, Duration duration, GreedyString warning) {
        String creatorName = source.method_9214();
        String targetPlayerName = (String)targetPlayer.getValue();
        String warningDescription = (String)warning.getValue();
        @Nullable Long expirationTimestamp = DurationParser.parseIntoExpirationTimestamp((String)duration.getValue()).orElse(null);
        String expirationDate = ChronosUtil.Formatter.formatDate(expirationTimestamp);
        WarningService.createWarning(creatorName, targetPlayerName, warningDescription, expirationTimestamp);
        TextHelper.sendTextByKey(source, "warning.created", targetPlayerName, expirationDate);
        return 1;
    }

    @Document(id=1751827040456L, value="List the warnings of a player.")
    @CommandNode(value="warning list")
    @CommandRequirement(level=4)
    private static int $listWarning(@CommandSource class_2168 source, OfflinePlayerName targetPlayer) {
        String targetPlayerName = (String)targetPlayer.getValue();
        PlayerWarnings playerWarnings = WarningService.getPlayerWarnings(targetPlayerName);
        TextHelper.sendTextByKey(source, "warning.list.message", targetPlayerName, playerWarnings.getWarnings().size());
        playerWarnings.getWarnings().forEach(warning -> {
            warning.asLore(source).forEach(text -> TextHelper.sendMessageByText(source, text));
            TextHelper.sendMessageByText(source, TextHelper.TEXT_EMPTY);
        });
        return 1;
    }

    @Document(id=1751827043371L, value="Clear the warnings of a player.")
    @CommandNode(value="warning clear")
    @CommandRequirement(level=4)
    private static int $clearWarning(@CommandSource class_2168 source, OfflinePlayerName targetPlayer, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            String targetPlayerName = (String)targetPlayer.getValue();
            int originalSize = WarningService.clearWarnings(targetPlayerName);
            TextHelper.sendTextByKey(source, "warning.clear", originalSize, targetPlayerName);
            return 1;
        });
    }

    @Document(id=1751827045167L, value="Clear all warnings for all players.")
    @CommandNode(value="warning clear-all")
    @CommandRequirement(level=4)
    private static int $clearAllWarnings(@CommandSource class_2168 source, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            WarningService.clearAllWarnings();
            TextHelper.sendTextByKey(source, "warning.clear_all", new Object[0]);
            return 1;
        });
    }

    @EventConsumer
    private static void notifyOnPlayerJoined(PlayerJoinedEvent event) {
        class_3222 player = event.getPlayer();
        WarningService.processNotify(player, true);
        WarningService.processWarningReminder(player);
    }

    @EventConsumer
    private static void notifyOnPlayerLeft(PlayerLeftEvent event) {
        WarningService.processNotify(event.getPlayer(), false);
    }

    @Override
    protected void registerPlaceholders() {
        WarningPlaceholders.registerLastWarningCreatedDatePlaceholder();
        WarningPlaceholders.registerLastWarningCreatorNamePlaceholder();
        WarningPlaceholders.registerLastWarningExpirationDatePlaceholder();
        WarningPlaceholders.registerLastWarningReasonPlaceholder();
    }
}

