/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.works.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.CrudPagedGui;
import io.github.sakurawald.fuji.core.gui.component.gui.PagedGui;
import io.github.sakurawald.fuji.core.structure.GlobalPos;
import io.github.sakurawald.fuji.module.initializer.works.WorksInitializer;
import io.github.sakurawald.fuji.module.initializer.works.gui.CreateWorkGui;
import io.github.sakurawald.fuji.module.initializer.works.structure.work.abst.Work;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListWorksGui
extends CrudPagedGui<Work> {
    public ListWorksGui(class_3222 player, @NotNull List<Work> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "works.list.title", new Object[0]), entities, pageIndex);
        if (ListWorksGui.isViewingAllWorks(entities)) {
            GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 5, (GuiElementBuilder)GuiHelper.Button.makeLetterAButton().setName(TextHelper.getTextByKey(player, "works.list.my_works", new Object[0])).setCallback(() -> this.linkCurrentGuiAndSearch(player.method_7334().getName()).open()));
        } else {
            GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 5, (GuiElementBuilder)GuiHelper.Button.makeHeartButton().setName(TextHelper.getTextByKey(player, "works.list.all_works", new Object[0])).setCallback(() -> new ListWorksGui(player, WorksInitializer.works.model().works, 0).open()));
        }
    }

    @Override
    protected PagedGui<Work> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<Work> entities, int pageIndex) {
        return new ListWorksGui(player, entities, pageIndex);
    }

    private static boolean isViewingAllWorks(@NotNull List<Work> entities) {
        return entities == WorksInitializer.works.model().works;
    }

    @Override
    protected GuiElementBuilder toGuiElementBuilder(Work entity) {
        class_3222 player = this.getPlayer();
        return GuiElementBuilder.from((class_1799)entity.getEntityIcon()).setName(TextHelper.getTextByValue(null, entity.name, new Object[0])).setLore(entity.ofLore(player));
    }

    @Override
    @NotNull
    protected String getGuiHelpLoreKey() {
        return "works.list.help.lore";
    }

    @Override
    protected void onCreateEntity() {
        new CreateWorkGui(this.getPlayer()).open();
    }

    private boolean canOperateOnThisEntity(@NotNull class_3222 player, @NotNull Work work) {
        return PlayerHelper.getPlayerName((class_1657)player).equals(work.creator) || CommandHelper.Requirement.isOperator((class_1657)player);
    }

    @Override
    protected boolean canCreateEntity() {
        return true;
    }

    @Override
    protected boolean canReadEntity(Work entity) {
        return true;
    }

    @Override
    protected boolean canUpdateEntity(Work entity) {
        return this.canOperateOnThisEntity(this.getPlayer(), entity);
    }

    @Override
    protected boolean canDeleteEntity(Work entity) {
        return this.canOperateOnThisEntity(this.getPlayer(), entity);
    }

    @Override
    protected void onLeftClickEntity(Work entity) {
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)RegistryHelper.makeIdentifierOrThrow(entity.level));
        class_3222 player = this.getPlayer();
        class_3218 dimension = ServerHelper.getServer().method_3847(worldKey);
        if (dimension != null) {
            new GlobalPos((class_1937)dimension, entity.x, entity.y, entity.z, entity.yaw, entity.pitch).teleport(player);
        } else {
            TextHelper.sendTextByKey(player, "world.dimension.not_found", entity.level);
        }
        this.close();
    }

    @Override
    protected void onRightShiftClickEntity(Work entity) {
        class_3222 player = this.getPlayer();
        if (!this.canUpdateEntity(entity)) {
            TextHelper.sendTextByKey(player, "works.work.set.no_perm", new Object[0]);
            return;
        }
        entity.openSpecializedSettingsGui(player, this.getBackendGui());
        this.close();
    }

    @Override
    protected void onRightClickEntity(Work entity) {
        class_3222 player = this.getPlayer();
        if (!this.canUpdateEntity(entity)) {
            TextHelper.sendTextByKey(player, "works.work.set.no_perm", new Object[0]);
            return;
        }
        entity.openGeneralSettingsGui(player, this.getBackendGui());
        this.close();
    }
}

