/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.works.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LogicHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.gui.component.gui.ConfirmSignGui;
import io.github.sakurawald.fuji.core.gui.component.gui.InputSignGui;
import io.github.sakurawald.fuji.module.initializer.works.WorksInitializer;
import io.github.sakurawald.fuji.module.initializer.works.structure.work.abst.Work;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class WorkGeneralSettingsGui
extends SimpleGui {
    public WorkGeneralSettingsGui(@NotNull SimpleGui parentGui, @NotNull class_3222 player, @NotNull Work work) {
        super(class_3917.field_18664, player, false);
        this.setTitle(TextHelper.getTextByKey(player, "works.work.set.general_settings.title", new Object[0]));
        this.placeSetEntityNameButton(player, work);
        this.placeSetEntityIconButton(player, work);
        this.placeSetEntityPositionButton(player, work);
        this.placeSetEntityIntroductionButton(player, work);
        this.placeSetEntityDeleteButton(player, work);
        this.setSlot(8, GuiHelper.Button.makePreviousPageButton(player).setCallback(() -> ((SimpleGui)parentGui).open()));
    }

    private void placeSetEntityDeleteButton(@NotNull class_3222 player, final @NotNull Work work) {
        this.addSlot(new GuiElementBuilder().setItem(class_1802.field_8077).setName(TextHelper.getTextByKey(player, "works.work.set.target.delete", new Object[0])).setCallback(() -> new ConfirmSignGui(this, player){

            @Override
            public void onConfirm() {
                WorksInitializer.works.model().works.remove(work);
                TextHelper.sendTextByKey(this.player, "works.work.delete.done", new Object[0]);
            }
        }.open()));
    }

    private void placeSetEntityIntroductionButton(@NotNull class_3222 player, @NotNull Work work) {
        this.addSlot(new GuiElementBuilder().setItem(class_1802.field_8892).setName(TextHelper.getTextByKey(player, "works.work.set.target.icon", new Object[0])).setCallback(() -> {
            class_1799 mainHandItem = player.method_6047();
            if (mainHandItem.method_7960()) {
                TextHelper.sendTextByKey(player, "works.work.set.target.icon.no_item", new Object[0]);
                this.close();
                return;
            }
            work.icon = RegistryHelper.getIdAsString(mainHandItem);
            TextHelper.sendTextByKey(player, "works.work.set.done", work.icon);
            this.close();
        }));
    }

    private void placeSetEntityPositionButton(@NotNull class_3222 player, @NotNull Work work) {
        this.addSlot(new GuiElementBuilder().setItem(class_1802.field_8827).setName(TextHelper.getTextByKey(player, "works.work.set.target.position", new Object[0])).setCallback(() -> {
            work.level = EntityHelper.getServerWorld((class_1297)player).method_27983().method_29177().toString();
            work.x = player.method_19538().field_1352;
            work.y = player.method_19538().field_1351;
            work.z = player.method_19538().field_1350;
            TextHelper.sendTextByKey(player, "works.work.set.done", "(%s, %f, %f, %f)".formatted(work.level, work.x, work.y, work.z));
            this.close();
        }));
    }

    private void placeSetEntityIconButton(@NotNull class_3222 player, final @NotNull Work work) {
        this.addSlot(new GuiElementBuilder().setItem(class_1802.field_42708).setName(TextHelper.getTextByKey(player, "works.work.set.target.introduction", new Object[0])).setCallback(() -> new InputSignGui(this, player, null){

            public void onClose() {
                String newIntroduction = this.joinStrings();
                LogicHelper.withCancelCheck(this.player, newIntroduction.isBlank(), () -> {
                    work2.introduction = newIntroduction;
                    TextHelper.sendTextByKey(this.player, "works.work.set.done", work2.introduction);
                });
            }
        }.open()));
    }

    private void placeSetEntityNameButton(@NotNull class_3222 player, final @NotNull Work work) {
        this.addSlot(new GuiElementBuilder().setItem(class_1802.field_8448).setName(TextHelper.getTextByKey(player, "works.work.set.target.name", new Object[0])).setCallback(() -> new InputSignGui(this, player, null){

            public void onClose() {
                String newValue = this.joinStrings();
                if (newValue.isBlank()) {
                    TextHelper.sendTextByKey(this.player, "works.work.add.empty_name", new Object[0]);
                    return;
                }
                work.name = newValue;
                TextHelper.sendTextByKey(this.player, "works.work.set.done", work.name);
            }
        }.open()));
    }
}

