/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.initializer.world.gamerule.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.class_1928;

@Document(id=1752254462732L, value="This structure is used to store the `game rules`.\nIt stores both `boolean rules` and `int rules`.\n")
public final class GameRuleStore {
    public Reference2BooleanMap<class_1928.class_4313<class_1928.class_4310>> booleanRules = new Reference2BooleanOpenHashMap();
    public Reference2IntMap<class_1928.class_4313<class_1928.class_4312>> intRules = new Reference2IntOpenHashMap();

    public void setBooleanRule(class_1928.class_4313<class_1928.class_4310> key, boolean value) {
        this.booleanRules.put(key, value);
    }

    public void setIntRule(class_1928.class_4313<class_1928.class_4312> key, int value) {
        this.intRules.put(key, value);
    }

    public boolean getBooleanRule(class_1928.class_4313<class_1928.class_4310> key) {
        return this.booleanRules.getBoolean(key);
    }

    public int getIntRule(class_1928.class_4313<class_1928.class_4312> key) {
        return this.intRules.getInt(key);
    }

    public boolean containsRule(class_1928.class_4313<?> key) {
        return this.booleanRules.containsKey(key) || this.intRules.containsKey(key);
    }

    public static class_1928 makeGameRules() {
        class_1928 gameRules = new class_1928(ServerHelper.getServer().method_30002().method_45162());
        return gameRules;
    }

    public static GameRuleStore makeDefaultGameRuleStore() {
        GameRuleStore defaultGameRuleStore = new GameRuleStore();
        defaultGameRuleStore.booleanRules.put((Object)class_1928.field_19389, true);
        defaultGameRuleStore.intRules.put((Object)class_1928.field_28357, 50);
        return defaultGameRuleStore;
    }

    public void applyTo(class_1928 rules) {
        Reference2BooleanMaps.fastForEach(this.booleanRules, entry -> {
            class_1928.class_4310 rule = (class_1928.class_4310)rules.method_20746((class_1928.class_4313)entry.getKey());
            rule.method_20758(entry.getBooleanValue(), ServerHelper.getServer());
        });
        Reference2IntMaps.fastForEach(this.intRules, entry -> {
            class_1928.class_4312 rule = (class_1928.class_4312)rules.method_20746((class_1928.class_4313)entry.getKey());
            rule.method_35236(entry.getIntValue(), ServerHelper.getServer());
        });
    }
}

