/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.mixin.core.command;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.fuji.core.command.extension.CommandContextBuilderExtension;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={CommandDispatcher.class})
public class CommandDispatcherMixin<S> {
    @ModifyVariable(method={"parseNodes"}, at=@At(value="STORE"), ordinal=2, remap=false)
    CommandContextBuilder passChildContextAfterRedirect(CommandContextBuilder<S> childContext, @Local(ordinal=1) CommandContextBuilder<S> parentContext) {
        CommandHelper.Source.withServerCommandSource(parentContext.getSource(), () -> {
            CommandContextBuilderExtension accessor = (CommandContextBuilderExtension)childContext;
            accessor.fuji$withArguments(parentContext.getArguments());
        });
        return childContext;
    }

    @WrapOperation(method={"getCompletionSuggestions(Lcom/mojang/brigadier/ParseResults;I)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;listSuggestions(Lcom/mojang/brigadier/context/CommandContext;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;")}, remap=false)
    CompletableFuture<Suggestions> checkRequirementWhenListCommandSuggestions(CommandNode<S> instance, CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder, Operation<CompletableFuture<Suggestions>> original, @Local(argsOnly=true) ParseResults<S> parse) {
        Object commandSource = parse.getContext().getSource();
        if (CommandHelper.Source.isExecutedOnServerSide(commandSource)) {
            if (instance.canUse(commandSource)) {
                return (CompletableFuture)original.call(new Object[]{instance, commandContext, suggestionsBuilder});
            }
            return Suggestions.empty();
        }
        return (CompletableFuture)original.call(new Object[]{instance, commandContext, suggestionsBuilder});
    }
}

