/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.mixin.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.AuthlibHelper;
import io.github.sakurawald.fuji.module.initializer.skin.service.SkinService;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3248;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class})
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    private GameProfile field_45029;
    @Unique
    CompletableFuture<Property> skinFuture;

    @Inject(method={"tickVerify"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;checkCanJoin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/text/Text;")}, cancellable=true)
    public void postponeTheLoginUntilTheSkinFetchingIsComplete(@NotNull CallbackInfo ci) {
        if (this.skinFuture == null) {
            this.skinFuture = CompletableFuture.supplyAsync(() -> SkinService.getEffectiveSkin(this.field_45029));
        }
        if (!this.skinFuture.isDone()) {
            ci.cancel();
        }
    }

    @Inject(method={"sendSuccessPacket"}, at={@At(value="HEAD")})
    void applyTheFetchedSkin(@NotNull GameProfile gameProfile, CallbackInfo ci) {
        if (this.skinFuture == null) {
            LogUtil.warn("Failed to modify the skin property for player {}. (It seems like the tickVerify() method is modified by other mods.)", this.field_45029.getName());
            return;
        }
        Property valueIfAbsent = SkinService.getPreferredDefaultSkin();
        AuthlibHelper.modifyGameProfile(this.field_45029, this.skinFuture.getNow(valueIfAbsent));
    }
}

