/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.chat.mention;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerChatMessagePreEvent;
import mod.fuji.core.job.impl.PlaySoundJob;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.chat.mention.config.model.ChatMentionConfigModel;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826738578L, value="This module allows players to `mention` other online players in chat:\n1. Name Highlighting: the mentioned player's name is visually highlighted.\n2. Sound Notification: the mentioned player receives an audible notification.\n")
@ColorBox(id=1751870571897L, color=ColorBox.ColorBoxTypes.WARNING, value="\u25c9 This module work partially with `Styled Chat` mod.\nYou can use this module with that mod.\nIt works, but you will not get the `mention player` rendered in chat.\nOther things like the `sound notify` will still work.\n")
public class ChatMentionInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatMentionConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatMentionConfigModel.class);

    private static List<class_3222> resolveMentionedOnlinePlayers(@NotNull String chatString) {
        return PlayerHelper.Lookup.getOnlinePlayerNames().stream().filter(playerName -> chatString.endsWith((String)playerName) || chatString.contains(playerName + " ")).sorted(Comparator.comparingInt(String::length).reversed()).map(PlayerHelper.Lookup::getOnlinePlayerByName).filter(Optional::isPresent).map(Optional::get).toList();
    }

    private static void submitMentionPlayersJob(@NotNull List<class_3222> mentionedPlayers) {
        if (!mentionedPlayers.isEmpty()) {
            LogUtil.debug("Submit new mention job: mentionedPlayers = {}", mentionedPlayers.stream().map(PlayerHelper::getPlayerName).toList());
            PlaySoundJob.scheduleJob(config.model().getMentionPlayer(), mentionedPlayers);
        }
    }

    @NotNull
    public static class_2561 replaceMentionText(@NotNull class_2561 text) {
        String chatString = TextHelper.Operators.getString(text);
        List<class_3222> mentionedPlayers = ChatMentionInitializer.resolveMentionedOnlinePlayers(chatString);
        ChatMentionInitializer.submitMentionPlayersJob(mentionedPlayers);
        for (class_3222 mentionedPlayer : mentionedPlayers) {
            String playerName = PlayerHelper.getPlayerName((class_1657)mentionedPlayer);
            String replacementString = config.model().getMentionFormat().formatted(playerName);
            class_2561 replacementText = TextHelper.getTextByValue(mentionedPlayer, replacementString, new Object[0]);
            text = TextHelper.Replacer.replaceTextWithRegex(text, Pattern.quote(playerName), matcher -> replacementText);
        }
        return text;
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=999)
    private static void handleOnPlayerChatEvent(PlayerChatMessagePreEvent event) {
        class_7471 signedMessage = event.getSignedMessage();
        class_2561 oldValue = signedMessage.method_46291();
        class_2561 newValue = ChatMentionInitializer.replaceMentionText(oldValue);
        class_7471 newSignedMessage = signedMessage.method_44863(newValue);
        event.setSignedMessage(newSignedMessage);
    }
}

