/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.mixin.command_permission;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import java.util.function.Predicate;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.module.initializer.command_permission.service.CommandPermissionService;
import mod.fuji.module.initializer.command_permission.structure.WrappedPredicate;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CommandNode.class}, remap=false)
public abstract class CommandNodeMixin {
    @Mutable
    @Shadow
    @Final
    private Predicate<Object> requirement;
    @Unique
    private Predicate<Object> previousWrappedPredicate;

    @ModifyReturnValue(method={"getRequirement"}, at={@At(value="RETURN")})
    Predicate<Object> wrapRequirementPredicateForThisCommandNode(Predicate<Object> original) {
        @Nullable CommandDispatcher<class_2168> dispatcher = CommandHelper.getCommandDispatcher();
        if (dispatcher == null) {
            LogUtil.debug("The CommandNode#getRequirement is triggered too early, fuji will just ignore this call.", new Object[0]);
            return original;
        }
        boolean shouldWrapIt = false;
        if (!(original instanceof WrappedPredicate)) {
            shouldWrapIt = true;
        } else if (!this.requirement.equals(this.previousWrappedPredicate)) {
            shouldWrapIt = true;
        }
        if (shouldWrapIt) {
            CommandNode node = (CommandNode)this;
            this.requirement = CommandPermissionService.makeWrappedPredicate((CommandNode<class_2168>)node, original);
            this.previousWrappedPredicate = this.requirement;
            return this.requirement;
        }
        return original;
    }
}

