/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.config.Configs;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChronosUtil {
    @NotNull
    public static ZoneId getPreferredZoneId() {
        return ZoneId.of("UTC");
    }

    @NotNull
    public static ZonedDateTime getZonedDateTime() {
        return ZonedDateTime.now(ChronosUtil.getPreferredZoneId());
    }

    @NotNull
    public static LocalDate getLocalDate() {
        return LocalDate.now(ChronosUtil.getPreferredZoneId());
    }

    @NotNull
    public static LocalTime getLocalTime() {
        return LocalTime.now(ChronosUtil.getPreferredZoneId());
    }

    @NotNull
    public static Long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public static long toTimestamp(@NotNull ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static long toTimestamp(@NotNull Date date) {
        return date.toInstant().toEpochMilli();
    }

    public static class Boundary {
        @NotNull
        public static ZonedDateTime getBeginningOfCurrentYear(ZonedDateTime now) {
            return now.withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
        }

        @NotNull
        public static ZonedDateTime getBeginningOfCurrentMonth(ZonedDateTime now) {
            return now.withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
        }

        @NotNull
        public static ZonedDateTime getBeginningOfCurrentWeek(ZonedDateTime now, DayOfWeek dayOfWeek) {
            return now.with(TemporalAdjusters.previousOrSame(dayOfWeek)).truncatedTo(ChronoUnit.DAYS);
        }

        @NotNull
        public static ZonedDateTime getBeginningOfCurrentHour(ZonedDateTime now) {
            return now.truncatedTo(ChronoUnit.HOURS);
        }

        @NotNull
        public static ZonedDateTime getBeginningOfTheDay(ZonedDateTime now) {
            return now.truncatedTo(ChronoUnit.DAYS);
        }
    }

    public static class Formatter {
        private static final String FALLBACK_DATE_FORMATTER_PATTERN = "yyyy-MM-dd HH:mm:ss";
        private static final DateTimeFormatter FALLBACK_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        private static String effectiveDateFormatterPattern = null;
        private static DateTimeFormatter effectiveDateFormatter = null;

        public static DateTimeFormatter getEffectiveDateFormatter() {
            String specifiedDateFormatterPattern = Configs.MAIN_CONTROL_CONFIG.model().core.formatter.date_formatter;
            if (effectiveDateFormatterPattern == null || !effectiveDateFormatterPattern.equals(specifiedDateFormatterPattern) && !effectiveDateFormatterPattern.equals(FALLBACK_DATE_FORMATTER_PATTERN)) {
                try {
                    effectiveDateFormatter = DateTimeFormatter.ofPattern(specifiedDateFormatterPattern);
                    effectiveDateFormatterPattern = specifiedDateFormatterPattern;
                }
                catch (Exception e) {
                    LogUtil.error("Failed to parse the specified date formatter pattern {}.\nFalling back to the default pattern {}.\nYou can read the syntax of date formatter in: https://docs.oracle.com/javase/8/docs/api/java/time/format/DateTimeFormatter.html\n", specifiedDateFormatterPattern, FALLBACK_DATE_FORMATTER_PATTERN);
                    effectiveDateFormatter = FALLBACK_DATE_FORMATTER;
                    effectiveDateFormatterPattern = FALLBACK_DATE_FORMATTER_PATTERN;
                }
            }
            return effectiveDateFormatter;
        }

        @NotNull
        public static String getFormattedCurrentDate() {
            DateTimeFormatter formatter = Formatter.getEffectiveDateFormatter();
            return Formatter.getFormattedCurrentDate(formatter);
        }

        @NotNull
        public static String getFormattedCurrentDate(DateTimeFormatter formatter) {
            return Formatter.formatDate(formatter, System.currentTimeMillis());
        }

        @NotNull
        public static String formatDate(@Nullable Long timeMillis) {
            return Formatter.formatDate(Formatter.getEffectiveDateFormatter(), timeMillis);
        }

        @NotNull
        public static String formatDate(@NotNull DateTimeFormatter formatter, @Nullable Long timeMillis) {
            if (timeMillis == null) {
                return "NONE";
            }
            ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timeMillis).atZone(ZoneId.systemDefault());
            return zonedDateTime.format(formatter);
        }
    }
}

