/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    public static String computeRelativePath(@NotNull File base, @NotNull File file) {
        String baseStr = base.getCanonicalPath();
        String fileStr = file.getCanonicalPath();
        Path basePath = Paths.get(baseStr, new String[0]);
        Path filePath = Paths.get(fileStr, new String[0]);
        Path relativize = basePath.relativize(filePath);
        return relativize.toString();
    }

    public static String computeRelativePathBasedOnGameDir(@NotNull File file) {
        File base = FabricLoader.getInstance().getGameDir().toFile();
        return IOUtil.computeRelativePath(base, file);
    }

    public static String makeValidWindowsFileName(@NotNull String fileName) {
        String invalidChars = "[<>:\"/\\|?*]";
        return fileName.replaceAll(invalidChars, "-");
    }

    @NotNull
    public static List<Path> listLatestFiles(@NotNull Path path) {
        List<Path> list;
        block8: {
            Stream<Path> files = Files.list(path);
            try {
                list = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted((o1, o2) -> {
                    try {
                        FileTime t1 = Files.readAttributes(o1, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                        FileTime t2 = Files.readAttributes(o2, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                        return t1.compareTo(t2);
                    }
                    catch (IOException e) {
                        throw ExceptionUtil.makeReThrownException(e);
                    }
                }).collect(Collectors.toList());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                if (files != null) {
                    try {
                        files.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            files.close();
        }
        return list;
    }

    public static void deleteDirectoryIfEmpty(@NotNull Path filePath) throws IOException {
        Stream<Path> $inputFiles = Files.list(filePath);
        try {
            if ($inputFiles.toList().isEmpty()) {
                Files.delete(filePath);
            }
        }
        finally {
            if (Collections.singletonList($inputFiles).get(0) != null) {
                $inputFiles.close();
            }
        }
    }

    public static class Compressor {
        public static void compressFiles(@NotNull File base, @NotNull List<File> input, @NotNull File output) {
            int BUFFER_SIZE = 4096;
            try (FileOutputStream fos = new FileOutputStream(output);
                 ZipOutputStream zos = new ZipOutputStream(fos);){
                for (File file : input) {
                    if (!file.isFile()) continue;
                    try (FileInputStream fis = new FileInputStream(file);){
                        int length;
                        ZipEntry zipEntry = new ZipEntry(Compressor.computeArchiveEntryName(base, file));
                        zos.putNextEntry(zipEntry);
                        byte[] buffer = new byte[4096];
                        while ((length = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, length);
                        }
                        zos.closeEntry();
                    }
                }
            }
        }

        @NotNull
        private static String computeArchiveEntryName(@NotNull File base, @NotNull File file) {
            return IOUtil.computeRelativePath(base, file);
        }
    }
}

