/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtHelper {

    public static class Primitives {
        public static Optional<String> getString(@NotNull class_2487 root, @NotNull String key) {
            return Optional.ofNullable(root.method_10558(key));
        }

        public static Optional<class_2487> getCompound(@NotNull class_2487 root, @NotNull String key) {
            return Optional.ofNullable(root.method_10562(key));
        }

        public static Optional<class_2487> getCompound(@NotNull class_2499 list, int index) {
            return Optional.ofNullable(list.method_10602(index));
        }

        public static Optional<Integer> getInt(@NotNull class_2487 root, @NotNull String key) {
            return Optional.of(root.method_10550(key));
        }

        public static Optional<Float> getFloat(@NotNull class_2487 root, @NotNull String key) {
            return Optional.of(Float.valueOf(root.method_10583(key)));
        }

        public static Optional<Double> getDouble(@NotNull class_2487 root, @NotNull String key) {
            return Optional.of(root.method_10574(key));
        }
    }

    public static class Storage {
        private static void writeNbtFile(@NotNull class_2487 root, @NotNull Path filePath) throws IOException {
            class_2507.method_10630((class_2487)root, (File)filePath.toFile());
        }

        @Nullable
        private static class_2487 readNbtFile(@NotNull Path filePath) throws IOException {
            return class_2507.method_10633((File)filePath.toFile());
        }

        public static <T> T withNbtFile(@NotNull Path filePath, @NotNull Function<class_2487, T> function) throws IOException {
            class_2487 nbt;
            if (Files.notExists(filePath, new LinkOption[0])) {
                Storage.writeNbtFile(new class_2487(), filePath);
            }
            if ((nbt = Storage.readNbtFile(filePath)) == null) {
                LogUtil.error("Failed to read the nbt file in {}", filePath);
                throw new AbortCommandExecutionException();
            }
            T value = function.apply(nbt);
            Storage.writeNbtFile(nbt, filePath);
            return value;
        }

        public static void withNbtFile(@NotNull Path filePath, @NotNull Consumer<class_2487> function) throws IOException {
            Storage.withNbtFile(filePath, (class_2487 root) -> {
                function.accept((class_2487)root);
                return null;
            });
        }
    }

    public static class Walker {
        private static void ensureKeysIsNotEmpty(@NotNull String nbtPath, String[] keys) {
            if (keys.length == 0) {
                throw new IllegalArgumentException("Failed to split the nbtPath %s".formatted(nbtPath));
            }
        }

        private static String @NotNull [] splitNbtPath(@NotNull String nbtPath) {
            return nbtPath.split("\\.", -1);
        }

        @NotNull
        private static IllegalStateException makeNbtElementTypeMismatchException(@NotNull String nbtPath) {
            return new IllegalStateException("The field in nbt path %s is not type of NbtCompound.".formatted(nbtPath));
        }

        private static <T extends class_2520> void setNbtPath(@NotNull class_2487 root, @NotNull String nbtPath, @NotNull T newValue) {
            String[] keys = Walker.splitNbtPath(nbtPath);
            Walker.ensureKeysIsNotEmpty(nbtPath, keys);
            for (int i = 0; i < keys.length - 1; ++i) {
                String node = keys[i];
                if (!root.method_10545(node)) {
                    root.method_10566(node, (class_2520)new class_2487());
                }
                root = Primitives.getCompound(root, node).orElseThrow(() -> {
                    LogUtil.error("Failed to set the value for specified nbt path: nbtPath = {}, newValue = {}", nbtPath, newValue);
                    return Walker.makeNbtElementTypeMismatchException(nbtPath);
                });
            }
            String theLastKey = keys[keys.length - 1];
            root.method_10566(theLastKey, newValue);
        }

        @Nullable
        private static class_2520 readNbtPath(@NotNull class_2487 root, @NotNull String nbtPath) {
            String[] keys = Walker.splitNbtPath(nbtPath);
            Walker.ensureKeysIsNotEmpty(nbtPath, keys);
            for (int i = 0; i < keys.length - 1; ++i) {
                String node = keys[i];
                if (!root.method_10545(node)) {
                    LogUtil.error("Failed to read the value of specified nbt path: root = {}, nbtPath = {} (There is no `{}` key)", root, nbtPath, node);
                    throw new IllegalStateException();
                }
                root = Primitives.getCompound(root, node).orElseThrow(() -> {
                    LogUtil.error("Failed to read the value of specified nbt path: nbtPath = {}", nbtPath);
                    return Walker.makeNbtElementTypeMismatchException(nbtPath);
                });
            }
            String theLastKey = keys[keys.length - 1];
            @Nullable class_2520 nbtElement = root.method_10580(theLastKey);
            return nbtElement;
        }

        public static <T extends class_2520> T getOrCreateNbtElement(@NotNull class_2487 root, @NotNull String nbtPath, @NotNull T defaultValue) {
            class_2520 nbtElement = Walker.readNbtPath(root, nbtPath);
            if (nbtElement == null) {
                Walker.setNbtPath(root, nbtPath, defaultValue);
                return defaultValue;
            }
            return (T)nbtElement;
        }
    }
}

