/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import io.github.sakurawald.fuji.core.document.descriptor.PlaceholderDescriptor;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderHelper {
    private static final String INVALID_ARGS_ERROR_REASON = "INVALID-ARGS-ERROR";
    private static final String NO_PLAYER_ERROR_REASON = "NO-PLAYER-ERROR";
    private static final String NO_SERVER_ERROR_REASON = "NO-SERVER-ERROR";

    @NotNull
    public static List<String> splitArguments(@Nullable String args) {
        if (args == null) {
            return List.of();
        }
        args = args.trim();
        String[] split = args.split("\\s+");
        return List.of(split);
    }

    public static class_2561 makeInvalidArgsErrorText() {
        return PlaceholderResult.invalid((String)INVALID_ARGS_ERROR_REASON).text();
    }

    public static void registerServerPlaceholder(@NotNull PlaceholderDescriptor descriptor, @NotNull BiFunction<MinecraftServer, String, class_2561> function) {
        PlaceholderHandler placeholderHandler = (ctx, args) -> {
            if (ctx.server() == null) {
                return PlaceholderResult.invalid((String)NO_SERVER_ERROR_REASON);
            }
            class_2561 resultText = (class_2561)function.apply(ctx.server(), args);
            return PlaceholderResult.value((class_2561)resultText);
        };
        String placeholderName = descriptor.getString();
        Placeholders.register((class_2960)class_2960.method_43902((String)"fuji", (String)placeholderName), (PlaceholderHandler)placeholderHandler);
    }

    public static void registerPlayerPlaceholder(@NotNull PlaceholderDescriptor descriptor, @NotNull BiFunction<class_3222, String, class_2561> function) {
        PlaceholderHandler placeholderHandler = (ctx, args) -> {
            if (ctx.player() == null) {
                return PlaceholderResult.invalid((String)NO_PLAYER_ERROR_REASON);
            }
            class_2561 resultText = (class_2561)function.apply(ctx.player(), args);
            return PlaceholderResult.value((class_2561)resultText);
        };
        String placeholderName = descriptor.getString();
        Placeholders.register((class_2960)class_2960.method_43902((String)"fuji", (String)placeholderName), (PlaceholderHandler)placeholderHandler);
    }

    public static void registerServerPlaceholder(@NotNull PlaceholderDescriptor descriptor, @NotNull Function<MinecraftServer, class_2561> function) {
        PlaceholderHelper.registerServerPlaceholder(descriptor, (MinecraftServer server, String args) -> (class_2561)function.apply((MinecraftServer)server));
    }

    public static void registerPlayerPlaceholder(@NotNull PlaceholderDescriptor descriptor, @NotNull Function<class_3222, class_2561> function) {
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, (class_3222 player, String args) -> (class_2561)function.apply((class_3222)player));
    }
}

