/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.authlib.GameProfile;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PacketHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TestCase(action="Consider special states of a player.", targets={"A player may be a fake-player from `carpet` mod.", "Once a player die, the old ServerPlayerEntity is invalid.", "A player may `disconnect` from the server.", "A player may in `spectator` game-mode.", "If a player is during the transferring of end portal, he is in no dimensions."})
public class PlayerHelper {
    public static String getPlayerName(@NotNull class_1657 player) {
        return player.method_7334().getName();
    }

    public static void playSound(@NotNull class_3222 player, @NotNull class_3414 soundEvent, @NotNull class_3419 soundCategory, float volume, float pitch) {
        player.method_17356(soundEvent, soundCategory, volume, pitch);
    }

    public static int getPing(@NotNull class_3222 player) {
        return player.field_13967;
    }

    public static boolean isRealPlayer(@NotNull class_3222 player) {
        return player.getClass() == class_3222.class;
    }

    public static boolean isServerPlayer(@NotNull class_1657 player) {
        return player instanceof class_3222;
    }

    @NotNull
    public static class_3218 getServerWorld(@NotNull class_3222 player) {
        return (class_3218)player.method_37908();
    }

    public static class_3324 getPlayerManager() {
        return ServerHelper.getServer().method_3760();
    }

    public static boolean isPlayerOnline(@NotNull String playerName) {
        return Lookup.getOnlinePlayerByName(playerName).isPresent();
    }

    public static void updateDisplayName(@NotNull class_3222 player) {
        class_2703 packet = new class_2703(class_2703.class_5893.field_29139, player);
        PacketHelper.sendPacketToAll(packet);
    }

    public static void updateDisplayNames() {
        Lookup.getOnlinePlayers().forEach(PlayerHelper::updateDisplayName);
    }

    public static void disconnectPlayer(@NotNull class_3222 target, @NotNull class_2561 reasonText) {
        target.field_13987.method_14367(reasonText);
    }

    public static void dismountRidingEntity(@NotNull class_3222 player) {
        player.method_5660(true);
        player.method_5842();
    }

    public static class Lookup {
        public static List<class_3222> getOnlinePlayers() {
            return PlayerHelper.getPlayerManager().method_14571();
        }

        public static List<String> getOnlinePlayerNames() {
            return Lookup.getOnlinePlayers().stream().map(PlayerHelper::getPlayerName).toList();
        }

        public static Optional<class_3222> getOnlinePlayerByName(@NotNull String playerName) {
            return Lookup.getOnlinePlayers().stream().filter(it -> PlayerHelper.getPlayerName((class_1657)it).equals(playerName)).findFirst();
        }

        public static Optional<class_3222> getOnlinePlayerByNameIgnoreCase(@NotNull String playerName) {
            return Lookup.getOnlinePlayers().stream().filter(it -> PlayerHelper.getPlayerName((class_1657)it).equalsIgnoreCase(playerName)).findFirst();
        }

        public static Optional<class_3222> getOnlinePlayerByUuid(@NotNull UUID playerUUID) {
            return Lookup.getOnlinePlayers().stream().filter(player -> player.method_5667().equals(playerUUID)).findFirst();
        }
    }

    public static class Cache {
        public static List<GameProfile> getOfflineGameProfiles() {
            class_3312 userCache = ServerHelper.getServer().method_3793();
            if (userCache == null) {
                return List.of();
            }
            return userCache.field_14312.values().stream().map(class_3312.class_3313::method_14519).toList();
        }

        @NotNull
        public static List<String> getOfflinePlayerNames() {
            return Cache.getOfflineGameProfiles().stream().map(GameProfile::getName).toList();
        }

        public static Optional<GameProfile> getOfflineGameProfileByName(@NotNull String playerName) {
            return Cache.getOfflineGameProfiles().stream().filter(it -> it.getName().equals(playerName)).findFirst();
        }
    }

    public static class Loader {
        private static final String DIMENSION_NBT_KEY = "Dimension";

        private static class_3222 makePlayer(@NotNull GameProfile gameProfile) {
            MinecraftServer server = ServerHelper.getServer();
            return new class_3222(server, server.method_30002(), gameProfile);
        }

        private static void applyPlayerData(@NotNull class_3222 player, @Nullable class_2487 playerData) {
            if (playerData == null) {
                return;
            }
            if (playerData.method_10545(DIMENSION_NBT_KEY)) {
                String dimensionId = NbtHelper.Primitives.getString(playerData, DIMENSION_NBT_KEY).get();
                Loader.setServerWorld(player, dimensionId);
            }
        }

        private static void setServerWorld(@NotNull class_3222 player, @Nullable String dimensionId) {
            Optional<class_3218> world = WorldHelper.getWorld(dimensionId);
            world.ifPresent(arg_0 -> ((class_3222)player).method_51468(arg_0));
        }

        public static class_3222 loadDummyPlayer(@NotNull String playerName) {
            Optional<class_3222> player = Lookup.getOnlinePlayerByName(playerName);
            if (player.isPresent()) {
                return player.get();
            }
            Optional<GameProfile> gameProfile = Cache.getOfflineGameProfileByName(playerName);
            if (gameProfile.isEmpty()) {
                throw new IllegalArgumentException("Can't find player %s in usercache.json file".formatted(playerName));
            }
            class_3222 $player = Loader.makePlayer(gameProfile.get());
            class_2487 playerData = PlayerHelper.getPlayerManager().method_14600($player);
            Loader.applyPlayerData($player, playerData);
            return $player;
        }
    }
}

