/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import java.util.function.Consumer;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TestCase(action="Consider the possible runtime environments.", targets={"The fabric server-side environment.", "The fabric client-side environment.", "The neo-forge server-side environment. (With `sinytra-connector` mod)", "The neo-forge client-side environment. (With `sinytra-connector` mod)", "The hybrid server (forge+bukkit) with `sinytra-connector` mod", "The GraalVM native image. (Which invalidates the reflection)"})
public class ServerHelper {
    private static MinecraftServer server;

    public static void executeSync(Runnable runnable) {
        ServerHelper.getServer().method_40000(runnable);
    }

    public static boolean isServerInstantiated() {
        return server != null;
    }

    public static void withServerInstantiated(Runnable runnable) {
        if (ServerHelper.isServerInstantiated()) {
            runnable.run();
        }
    }

    public static boolean isClientSideIntegratedServer() {
        return ServerHelper.getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isServerSideDedicatedServer() {
        return ServerHelper.getEnvironmentType() == EnvType.SERVER;
    }

    @NotNull
    public static EnvType getEnvironmentType() {
        return FabricLoader.getInstance().getEnvironmentType();
    }

    public static void withServerPlayerEntity(@Nullable class_1657 player, @NotNull Consumer<class_3222> consumer) {
        if (player == null) {
            return;
        }
        if (!PlayerHelper.isServerPlayer(player)) {
            return;
        }
        consumer.accept((class_3222)player);
    }

    public static void withServerPlayerEntity(@Nullable class_1657 player, @NotNull Runnable runnable) {
        ServerHelper.withServerPlayerEntity(player, (class_3222 serverPlayerEntity) -> runnable.run());
    }

    @NotNull
    public static ModContainer getSelfModContainer() {
        return (ModContainer)FabricLoader.getInstance().getModContainer("fuji").orElseThrow(() -> new IllegalStateException("Failed to get 'fuji' mod container."));
    }

    public static void withDevelopmentEnvironment(@NotNull Runnable runnable) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            runnable.run();
        }
    }

    @Generated
    public static MinecraftServer getServer() {
        return server;
    }

    @Generated
    public static void setServer(MinecraftServer server) {
        ServerHelper.server = server;
    }
}

