/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.RandomUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ItemStackHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.fuji.core.structure.GlobalBlockPos;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UuidHelper {
    private static final String FUJI_UUID_NBT_KEY = "fuji$uuid";

    @NotNull
    public static String convertStringToUUID(@NotNull String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return UUID.nameUUIDFromBytes(bytes).toString();
    }

    public static Optional<String> getAttachedUuid(@Nullable class_2487 root) {
        if (root == null) {
            return Optional.empty();
        }
        if (!root.method_10545(FUJI_UUID_NBT_KEY)) {
            return Optional.empty();
        }
        return NbtHelper.Primitives.getString(root, FUJI_UUID_NBT_KEY);
    }

    public static Optional<String> getAttachedUuid(@NotNull class_1799 itemStack) {
        @Nullable class_2487 customDataNbt = ItemStackHelper.CustomData.getCustomDataNbt(itemStack);
        return UuidHelper.getAttachedUuid(customDataNbt);
    }

    @NotNull
    public static String getAttachedUuid(@NotNull class_1297 entity) {
        return entity.method_5845();
    }

    public static String getAttachedUuid(@NotNull GlobalBlockPos globalBlockPos) {
        class_3218 dimension = WorldHelper.getWorldOrThrow(globalBlockPos.getDimension());
        class_2338 blockPos = globalBlockPos.toBlockPos();
        return UuidHelper.getAttachedUuid((class_1937)dimension, blockPos);
    }

    @NotNull
    public static String getAttachedUuid(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        String string = UuidHelper.toString(world, blockPos);
        return UuidHelper.convertStringToUUID(string);
    }

    @NotNull
    public static String toString(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        String dimensionString = RegistryHelper.getIdAsString(world);
        String blockPosString = blockPos.method_10263() + "#" + blockPos.method_10264() + "#" + blockPos.method_10260();
        return dimensionString + "#" + blockPosString;
    }

    @NotNull
    public static String getOrSetAttachedUuid(@NotNull class_1799 itemStack) {
        class_2487 nbt = ItemStackHelper.CustomData.getCustomDataNbt(itemStack);
        return UuidHelper.getAttachedUuid(nbt).orElseGet(() -> {
            class_2487 newValue = UuidHelper.attachRandomUuidToNbtCompoundIfAbsent(nbt);
            ItemStackHelper.CustomData.setCustomDataNbt(itemStack, newValue);
            return UuidHelper.getAttachedUuid(newValue).orElseThrow(() -> {
                LogUtil.error("Failed to set UUID for item stack: {}", itemStack);
                return new IllegalArgumentException("Failed to set UUID for item stack: " + String.valueOf(itemStack));
            });
        });
    }

    @NotNull
    private static class_2487 attachRandomUuidToNbtCompoundIfAbsent(@Nullable class_2487 root) {
        if (root == null) {
            root = new class_2487();
        }
        if (!root.method_10545(FUJI_UUID_NBT_KEY)) {
            String uuidString = RandomUtil.randomUUID();
            root.method_10582(FUJI_UUID_NBT_KEY, uuidString);
        }
        return root;
    }
}

