/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.argument.adapter.abst;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import io.github.sakurawald.fuji.core.auxiliary.ExceptionUtil;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.command.argument.structure.CommandArgument;
import io.github.sakurawald.fuji.core.command.assistant.CommandAssistant;
import io.github.sakurawald.fuji.core.command.suggestion.structure.ComposedCommandSuggestionsProvider;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.document.interfaces.SourceModuleGetter;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleLoadDeterminer;
import io.github.sakurawald.fuji.core.manager.impl.module.ModulePathResolver;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.jetbrains.annotations.NotNull;

public abstract class BaseArgumentTypeAdapter
implements SourceModuleGetter {
    private boolean supportsTypeClass(@NotNull Class<?> typeClass) {
        return this.getTypeClasses().stream().anyMatch(it -> it.equals(typeClass));
    }

    public abstract List<Class<?>> getTypeClasses();

    public abstract List<String> getTypeNames();

    protected abstract ArgumentType<?> makeArgumentType();

    protected abstract Object makeArgumentValue(@NotNull CommandContext<class_2168> var1, @NotNull CommandArgument var2);

    @NotNull
    public final RequiredArgumentBuilder<class_2168, ?> makeComposedRequiredArgumentBuilder(@NotNull String argumentName) {
        RequiredArgumentBuilder<class_2168, ?> result = this.makeRequiredArgumentBuilder(argumentName);
        if (Configs.MAIN_CONTROL_CONFIG.model().core.command.assistant.enable) {
            ComposedCommandSuggestionsProvider composedCommandSuggestionsProvider = new ComposedCommandSuggestionsProvider(result.getType(), (SuggestionProvider<class_2168>)result.getSuggestionsProvider(), CommandAssistant::assist);
            result.suggests((SuggestionProvider)composedCommandSuggestionsProvider);
        }
        return result;
    }

    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        ArgumentType<?> argumentType = this.makeArgumentType();
        return class_2170.method_9244((String)argumentName, argumentType);
    }

    @NotNull
    public final Object makeParameterValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        Object argumentValue = this.makeArgumentValue(context, commandArgument);
        if (commandArgument.isOptional()) {
            return Optional.of(argumentValue);
        }
        return argumentValue;
    }

    public boolean verifyCommandSource(@NotNull CommandContext<class_2168> context) {
        return true;
    }

    public boolean isVanillaMinecraftArgumentType() {
        return this.getTypeClasses().stream().anyMatch(argumentClass -> {
            String className = argumentClass.getName();
            return className.startsWith("net.minecraft") || className.startsWith("com.mojang") || className.startsWith("java.lang");
        });
    }

    @Override
    @NotNull
    public String getSourceModule() {
        return ModulePathResolver.computeModulePathString(this.getClass().getName());
    }

    public static class Registry {
        public static final List<BaseArgumentTypeAdapter> REGISTERED_COMMAND_ARGUMENT_TYPE_ADAPTERS = new ArrayList<BaseArgumentTypeAdapter>();
        private static final Map<String, Class<?>> PREDEFINED_ARGUMENT_TYPES = new HashMap<String, Class<?>>(){
            {
                this.put("str", String.class);
                this.put("int", Integer.TYPE);
            }
        };
        private static final Map<String, Class<?>> TYPE_STRING_2_TYPE_CLASS = new HashMap<String, Class<?>>(){
            {
                this.putAll(PREDEFINED_ARGUMENT_TYPES);
            }
        };

        public static void registerTypeAdapters() {
            REGISTERED_COMMAND_ARGUMENT_TYPE_ADAPTERS.clear();
            TYPE_STRING_2_TYPE_CLASS.clear();
            ReflectionUtil.CompileTimeGraph.getCompileTimeTxtGraph("argument-type-adapter-graph.txt").stream().filter(className -> ModuleLoadDeterminer.shouldLoadThis(className)).forEach(className -> {
                try {
                    Class<?> adapterClass = Class.forName(className);
                    Constructor<?> adapterConstructor = adapterClass.getDeclaredConstructor(new Class[0]);
                    BaseArgumentTypeAdapter adapterInstance = (BaseArgumentTypeAdapter)adapterConstructor.newInstance(new Object[0]);
                    REGISTERED_COMMAND_ARGUMENT_TYPE_ADAPTERS.add(adapterInstance);
                    Class<?> adaptedTypeClass = adapterInstance.getTypeClasses().get(0);
                    adapterInstance.getTypeNames().forEach(typeString -> {
                        if (TYPE_STRING_2_TYPE_CLASS.containsKey(typeString) && !PREDEFINED_ARGUMENT_TYPES.containsKey(typeString)) {
                            throw new IllegalStateException("Type string `%s` is already registered.".formatted(typeString));
                        }
                        TYPE_STRING_2_TYPE_CLASS.put((String)typeString, adaptedTypeClass);
                    });
                }
                catch (Exception e) {
                    LogUtil.error("Failed to register an argument type adapter: className = {}", className);
                    throw ExceptionUtil.makeReThrownException(e);
                }
            });
        }

        @NotNull
        public static Class<?> toTypeClass(@NotNull String typeString) {
            Class<?> typeClass = TYPE_STRING_2_TYPE_CLASS.get(typeString);
            if (typeClass == null) {
                throw new IllegalArgumentException("Unknown argument string '%s'".formatted(typeString));
            }
            return typeClass;
        }

        @NotNull
        public static BaseArgumentTypeAdapter getTypeAdapter(@NotNull Class<?> typeClass) {
            for (BaseArgumentTypeAdapter adapter : REGISTERED_COMMAND_ARGUMENT_TYPE_ADAPTERS) {
                if (!adapter.supportsTypeClass(typeClass)) continue;
                return adapter;
            }
            throw new RuntimeException("No type adapter supports the type class: " + typeClass.getTypeName());
        }
    }
}

