/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.executor.structure;

import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.descriptor.CommandDescriptor;
import lombok.Generated;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public final class ExtendedCommandSource {
    @NotNull
    private final class_2168 initiatingSource;
    @NotNull
    private final class_2168 executingSource;
    private final boolean parsePlaceholders;

    public ExtendedCommandSource(@NotNull class_2168 initiatingSource, @NotNull class_2168 executingSource, boolean parsePlaceholders) {
        this.initiatingSource = initiatingSource;
        this.executingSource = CommandDescriptor.silentSpecialVariable.get() != false ? executingSource.method_9217() : executingSource;
        this.parsePlaceholders = parsePlaceholders;
    }

    public static ExtendedCommandSource fromSource(@NotNull class_2168 initiatingSource) {
        return new ExtendedCommandSource(initiatingSource, initiatingSource, true);
    }

    public static ExtendedCommandSource asConsole(@NotNull class_2168 initiatingSource) {
        return new ExtendedCommandSource(initiatingSource, ServerHelper.getServer().method_3739(), true);
    }

    public static ExtendedCommandSource asPlayer(@NotNull class_2168 initiatingSource, class_3222 executingPlayer) {
        return new ExtendedCommandSource(initiatingSource, executingPlayer.method_5671(), true);
    }

    public static ExtendedCommandSource asFakeOp(@NotNull class_2168 initiatingSource, class_3222 executingPlayer) {
        return new ExtendedCommandSource(initiatingSource, executingPlayer.method_5671().method_9206(4), true);
    }

    public boolean sameSource() {
        return this.executingSource.method_9214().equals(this.initiatingSource.method_9214());
    }

    private class_2168 getCommandSourceForPlaceholderParsing() {
        if (this.executingSource.method_43737()) {
            return this.executingSource;
        }
        return this.initiatingSource;
    }

    public String expandCommand(String string) {
        if (!this.parsePlaceholders) {
            return string;
        }
        class_3222 contextualPlayer = this.getCommandSourceForPlaceholderParsing().method_44023();
        string = contextualPlayer != null ? TextHelper.Parsers.parsePlaceholderString(contextualPlayer, string) : TextHelper.Parsers.parsePlaceholderString(ServerHelper.getServer(), string);
        return string;
    }

    public String toString() {
        return "ExtendedCommandSource{initiatingSource=" + this.initiatingSource.method_9214() + ", executingSource=" + this.executingSource.method_9214() + ", parsePlaceholder=" + this.parsePlaceholders + "}";
    }

    @NotNull
    @Generated
    public class_2168 getInitiatingSource() {
        return this.initiatingSource;
    }

    @NotNull
    @Generated
    public class_2168 getExecutingSource() {
        return this.executingSource;
    }

    @Generated
    public boolean isParsePlaceholders() {
        return this.parsePlaceholders;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendedCommandSource)) {
            return false;
        }
        ExtendedCommandSource other = (ExtendedCommandSource)o;
        if (this.isParsePlaceholders() != other.isParsePlaceholders()) {
            return false;
        }
        class_2168 this$initiatingSource = this.getInitiatingSource();
        class_2168 other$initiatingSource = other.getInitiatingSource();
        if (this$initiatingSource == null ? other$initiatingSource != null : !this$initiatingSource.equals(other$initiatingSource)) {
            return false;
        }
        class_2168 this$executingSource = this.getExecutingSource();
        class_2168 other$executingSource = other.getExecutingSource();
        return !(this$executingSource == null ? other$executingSource != null : !this$executingSource.equals(other$executingSource));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isParsePlaceholders() ? 79 : 97);
        class_2168 $initiatingSource = this.getInitiatingSource();
        result = result * 59 + ($initiatingSource == null ? 43 : $initiatingSource.hashCode());
        class_2168 $executingSource = this.getExecutingSource();
        result = result * 59 + ($executingSource == null ? 43 : $executingSource.hashCode());
        return result;
    }
}

