/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.suggestion;

import io.github.sakurawald.fuji.core.auxiliary.StringUtil;
import io.github.sakurawald.fuji.core.command.suggestion.structure.CommandSuggestionCandidate;
import io.github.sakurawald.fuji.core.document.annotation.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@TestCase(action="Issue `/when-online ...` and `/json put 1 2 3 ...` commands.", targets={"The command suggestion optimizer should work fine."})
public class CommandSuggestionOptimizer {
    public static <T> List<String> optimize(@NotNull Iterable<T> iterable, @NotNull String keyword) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (T value : iterable) {
            candidates.add(value.toString());
        }
        if (keyword.isBlank()) {
            return candidates;
        }
        return candidates.stream().map(string -> {
            String stringLowerCase = StringUtil.toLowerCase(string);
            String keywordLowerCase = StringUtil.toLowerCase(keyword);
            int distance = 0;
            if (!stringLowerCase.startsWith(keywordLowerCase)) {
                distance += 1000;
            }
            return new CommandSuggestionCandidate((String)string, distance);
        }).filter(it -> it.getScore() < 100).map(CommandSuggestionCandidate::getSuggestion).toList();
    }
}

