/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.handler.impl;

import com.google.gson.JsonObject;
import io.github.sakurawald.fuji.Fuji;
import io.github.sakurawald.fuji.core.config.exception.FailedToLoadResourceException;
import io.github.sakurawald.fuji.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.fuji.core.config.mapper.GsonMapper;
import io.github.sakurawald.fuji.core.config.validator.MissingJsonKeysValidator;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceConfigurationHandler
extends BaseConfigurationHandler<JsonObject> {
    @NotNull
    protected final String resourceClassPath;

    protected ResourceConfigurationHandler(@NotNull Path filePath, @NotNull String resourceClassPath) {
        super(filePath);
        this.resourceClassPath = resourceClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected static JsonObject loadJsonFileFromResourceClassPath(@NotNull String resourceClassPath) {
        JsonObject jsonObject;
        block7: {
            InputStream inputStream = Fuji.class.getResourceAsStream(resourceClassPath);
            if (inputStream == null) {
                throw new FailedToLoadResourceException("Failed to load specified resource file from class path: %s".formatted(resourceClassPath));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            try {
                jsonObject = GsonMapper.fromJson(reader, JsonObject.class);
                if (Collections.singletonList(reader).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(reader).get(0) != null) {
                    ((Reader)reader).close();
                }
                throw throwable;
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    @Override
    protected void validateModel(@NotNull JsonObject dataTree, @NotNull JsonObject schemaTree) {
        MissingJsonKeysValidator.mergeTrees(this, dataTree, schemaTree);
    }
}

