/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.mapper.adapter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class BiMapAdapter<V>
extends TypeAdapter<BiMap<String, V>> {
    private final TypeAdapter<V> valueTypeAdapter;

    public BiMapAdapter(TypeAdapter<V> valueTypeAdapter) {
        this.valueTypeAdapter = valueTypeAdapter;
    }

    public void write(JsonWriter out, BiMap<String, V> biMap) throws IOException {
        out.beginObject();
        for (Map.Entry entry : biMap.entrySet()) {
            out.name(String.valueOf(entry.getKey()));
            this.valueTypeAdapter.write(out, entry.getValue());
        }
        out.endObject();
    }

    public BiMap<String, V> read(JsonReader in) throws IOException {
        HashBiMap biMap = HashBiMap.create();
        in.beginObject();
        while (in.hasNext()) {
            String key = in.nextName();
            Object value = this.valueTypeAdapter.read(in);
            biMap.put((Object)key, value);
        }
        in.endObject();
        return biMap;
    }
}

