/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.config.mapper.wrapper;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameProfileWrapper {
    @Nullable(value="For an invalid online player name, the UUID is null.")
    private @Nullable(value="For an invalid online player name, the UUID is null.") UUID id;
    @NotNull
    private String name;
    @NotNull
    private PropertyMap properties = new PropertyMap();

    public GameProfileWrapper(@Nullable UUID id, @NotNull String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public static GameProfileWrapper fromVanillaType(@NotNull GameProfile gameProfile) {
        GameProfileWrapper gameProfileWrapper = new GameProfileWrapper(gameProfile.getId(), gameProfile.getName());
        gameProfileWrapper.properties.putAll((Multimap)gameProfile.getProperties());
        return gameProfileWrapper;
    }

    public Optional<GameProfile> toVanillaType() {
        if (this.id == null) {
            return Optional.empty();
        }
        GameProfile gameProfile = new GameProfile(this.id, this.name);
        gameProfile.getProperties().putAll((Multimap)this.properties);
        return Optional.of(gameProfile);
    }

    @Nullable(value="For an invalid online player name, the UUID is null.")
    @Generated
    public @Nullable(value="For an invalid online player name, the UUID is null.") UUID getId() {
        return this.id;
    }

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @NotNull
    @Generated
    public PropertyMap getProperties() {
        return this.properties;
    }

    @Generated
    public GameProfileWrapper setId(@Nullable(value="For an invalid online player name, the UUID is null.") @Nullable(value="For an invalid online player name, the UUID is null.") UUID id) {
        this.id = id;
        return this;
    }

    @Generated
    public GameProfileWrapper setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        return this;
    }

    @Generated
    public GameProfileWrapper setProperties(@NotNull PropertyMap properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = properties;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GameProfileWrapper)) {
            return false;
        }
        GameProfileWrapper other = (GameProfileWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PropertyMap this$properties = this.getProperties();
        PropertyMap other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GameProfileWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PropertyMap $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GameProfileWrapper(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    @Generated
    public GameProfileWrapper() {
    }

    @Generated
    public GameProfileWrapper(@Nullable(value="For an invalid online player name, the UUID is null.") @Nullable(value="For an invalid online player name, the UUID is null.") UUID id, @NotNull String name, @NotNull PropertyMap properties) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.properties = properties;
    }
}

